/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class ValueUtil {
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;

    private ValueUtil() {
    }

    public static String formatValue(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return ValueUtil.formatValue(number);
        }
        return object.toString();
    }

    public static String formatValue(Number number) {
        double value = number.doubleValue();
        if (DoubleMath.isMathematicalInteger((double)value)) {
            return Long.toString((long)value);
        }
        return number.toString();
    }

    public static String formatArrayValue(List<String> values) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String value : values) {
            if (value == null || "".equals(value)) {
                throw new IllegalArgumentException();
            }
            sb.append(sep);
            sep = " ";
            if (value.indexOf(32) > -1) {
                sb.append('\"').append(value).append('\"');
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static boolean isZero(Number number) {
        return ValueUtil.equals(number, ZERO);
    }

    public static boolean isOne(Number number) {
        return ValueUtil.equals(number, ONE);
    }

    public static int asInt(Number number) {
        if (number instanceof Integer) {
            return (Integer)number;
        }
        double value = number.doubleValue();
        if (DoubleMath.isMathematicalInteger((double)value)) {
            return Ints.checkedCast((long)((long)value));
        }
        throw new IllegalArgumentException();
    }

    public static Integer asInteger(Number number) {
        return ValueUtil.asInt(number);
    }

    public static List<Integer> asIntegers(List<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        Function<Number, Integer> function = new Function<Number, Integer>(){

            public Integer apply(Number number) {
                return ValueUtil.asInteger(number);
            }
        };
        return Lists.transform(numbers, (Function)function);
    }

    public static Double asDouble(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public static List<Double> asDoubles(List<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        Function<Number, Double> function = new Function<Number, Double>(){

            public Double apply(Number number) {
                return ValueUtil.asDouble(number);
            }
        };
        return Lists.transform(numbers, (Function)function);
    }

    public static Double floatToDouble(Float value) {
        return Double.parseDouble(Float.toString(value.floatValue()));
    }

    public static List<Double> floatsToDoubles(List<Float> values) {
        Function<Float, Double> function = new Function<Float, Double>(){

            public Double apply(Float value) {
                return ValueUtil.floatToDouble(value);
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public static BitSet getIndices(List<? extends Number> values, Number targetValue) {
        BitSet result = new BitSet(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Number value = values.get(i);
            if (!ValueUtil.equals(value, targetValue)) continue;
            result.set(i, true);
        }
        return result;
    }

    public static boolean isSparse(List<? extends Number> values, Number defaultValue, double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) continue;
            ++count;
        }
        return (double)count / (double)values.size() >= threshold;
    }

    public static <E> List<E> filterByIndices(List<E> list, BitSet filter) {
        ArrayList<E> result = new ArrayList<E>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            E element = list.get(i);
            if (!filter.get(i)) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean equals(Number value, Number targetValue) {
        if (value.equals(targetValue)) {
            return true;
        }
        return value.doubleValue() == targetValue.doubleValue();
    }
}

