/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.spark;

import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.jpmml.evaluator.spark.DatasetUtil;

public class ColumnExploder
extends Transformer {
    private String structCol = null;

    public ColumnExploder(String structCol) {
        this.setStructCol(structCol);
    }

    public String uid() {
        return null;
    }

    public ColumnExploder copy(ParamMap extra) {
        throw new UnsupportedOperationException();
    }

    public StructType transformSchema(StructType schema) {
        StructField[] fields;
        StructType structSchema = this.getStructSchema(schema);
        StructType result = schema;
        for (StructField field : fields = structSchema.fields()) {
            result = result.add(field);
        }
        return result;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        StructField[] fields;
        StructType schema = dataset.schema();
        StructType structSchema = this.getStructSchema(schema);
        Column structColumn = dataset.apply(DatasetUtil.escapeColumnName(this.getStructCol()));
        Dataset result = dataset.toDF();
        for (StructField field : fields = structSchema.fields()) {
            String name = field.name();
            Column fieldColumn = structColumn.getField(DatasetUtil.escapeColumnName(name));
            result = result.withColumn(DatasetUtil.escapeColumnName(name), fieldColumn);
        }
        return result;
    }

    private StructType getStructSchema(StructType schema) {
        StructField structField = schema.apply(this.getStructCol());
        return (StructType)structField.dataType();
    }

    public String getStructCol() {
        return this.structCol;
    }

    private void setStructCol(String structCol) {
        this.structCol = structCol;
    }
}

