/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.spark;

import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.spark.ColumnProducer;
import org.jpmml.evaluator.spark.SchemaUtil;

class OutputColumnProducer
extends ColumnProducer<OutputField> {
    private boolean formatString = false;

    OutputColumnProducer(OutputField field, String columnName) {
        super(field, columnName != null ? columnName : OutputColumnProducer.getName(field));
    }

    @Override
    public StructField init(Evaluator evaluator) {
        OutputField field = (OutputField)this.getField();
        DataType dataType = field.getDataType();
        if (dataType == null) {
            dataType = DataType.STRING;
            this.formatString = true;
        }
        return DataTypes.createStructField((String)this.getColumnName(), (org.apache.spark.sql.types.DataType)SchemaUtil.translateDataType(dataType), (boolean)false);
    }

    @Override
    public Object format(Object value) {
        if (this.formatString) {
            return value.toString();
        }
        return value;
    }

    private static String getName(OutputField field) {
        return field.getName().getValue();
    }
}

