/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Interaction;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class InteractionConverter
extends FeatureConverter<Interaction> {
    public InteractionConverter(Interaction transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        Interaction transformer = (Interaction)this.getTransformer();
        String name = "";
        List<Feature> result = new ArrayList<Feature>();
        String[] inputCols = transformer.getInputCols();
        for (int i = 0; i < inputCols.length; ++i) {
            String inputCol = inputCols[i];
            List<Feature> features = encoder.getFeatures(inputCol);
            if (i == 0) {
                name = inputCol;
                result = features;
                continue;
            }
            name = name + ":" + inputCol;
            ArrayList<InteractionFeature> interactionFeatures = new ArrayList<InteractionFeature>();
            int index = 0;
            for (Feature left : result) {
                for (Feature right : features) {
                    interactionFeatures.add(new InteractionFeature((PMMLEncoder)encoder, FieldName.create((String)(name + "[" + index + "]")), DataType.DOUBLE, Arrays.asList(left, right)));
                    ++index;
                }
            }
            result = interactionFeatures;
        }
        return result;
    }
}

