/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ArrayManager<E> {
    private JType componentType = null;
    private String name = null;
    private JFieldVar arrayVar = null;
    private JArray array = null;
    private Map<E, Integer> indices = new LinkedHashMap<E, Integer>();

    public ArrayManager(JType componentType, String name) {
        this.setComponentType(componentType);
        this.setName(name);
    }

    public abstract JExpression createExpression(E var1);

    public void initArrayVar(JDefinedClass owner) {
        JType componentType = this.getComponentType();
        String name = this.getName();
        this.arrayVar = owner.field(28, (JType)componentType.array(), name);
    }

    public void initArray() {
        JType componentType = this.getComponentType();
        if (this.arrayVar == null) {
            throw new IllegalStateException();
        }
        this.array = JExpr.newArray((JType)componentType);
        this.arrayVar.init((JExpression)this.array);
        Set<Map.Entry<E, Integer>> entries = this.indices.entrySet();
        for (Map.Entry entry : entries) {
            Object element = entry.getKey();
            this.array.add(this.createExpression(element));
        }
    }

    public int size() {
        return this.indices.size();
    }

    public Collection<E> getElements() {
        return this.indices.keySet();
    }

    public int getOrInsert(E element) {
        Integer index = this.indices.get(element);
        if (index == null) {
            if (this.array != null) {
                this.array.add(this.createExpression(element));
            }
            index = this.indices.size();
            this.indices.put(element, index);
        }
        return index;
    }

    public JExpression getComponent(int index) {
        return this.getComponent(JExpr.lit((int)index));
    }

    public JExpression getComponent(JExpression indexExpr) {
        if (this.arrayVar == null) {
            throw new IllegalStateException();
        }
        return this.arrayVar.component(indexExpr);
    }

    public JType getComponentType() {
        return this.componentType;
    }

    private void setComponentType(JType componentType) {
        this.componentType = Objects.requireNonNull(componentType);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public JFieldVar getArrayVar() {
        return this.arrayVar;
    }

    public JArray getArray() {
        return this.array;
    }
}

