/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.util.Objects;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.translator.Encoder;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.IdentifierUtil;

public class FieldInfo {
    private Field<?> field = null;
    private FieldInfo ref = null;
    private FunctionInvocation functionInvocation = null;
    private Integer count = null;
    private Encoder encoder = null;
    private String variableName = null;
    private String memberName = null;

    public FieldInfo(Field<?> field) {
        this(field, null);
    }

    public FieldInfo(Field<?> field, Encoder encoder) {
        this.setField(field);
        this.setEncoder(encoder);
    }

    public Field<?> getField() {
        return this.field;
    }

    private void setField(Field<?> field) {
        this.field = Objects.requireNonNull(field);
    }

    public FieldInfo getRef() {
        return this.ref;
    }

    public void setRef(FieldInfo ref) {
        this.ref = ref;
    }

    public FunctionInvocation getFunctionInvocation() {
        return this.functionInvocation;
    }

    public void setFunctionInvocation(FunctionInvocation functionInvocation) {
        this.functionInvocation = functionInvocation;
    }

    public void updateCount(Integer count) {
        if (count == null) {
            return;
        }
        if (this.count == null) {
            this.count = count;
        } else {
            FieldInfo fieldInfo = this;
            fieldInfo.count = fieldInfo.count + count;
        }
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public String getVariableName() {
        if (this.variableName == null) {
            this.variableName = this.createVariableName();
        }
        return this.variableName;
    }

    public void setVariableName(String varibaleName) {
        this.variableName = varibaleName;
    }

    public String getMemberName() {
        if (this.memberName == null) {
            this.memberName = this.createMemberName();
        }
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    private String createVariableName() {
        Encoder encoder = this.getEncoder();
        if (encoder != null) {
            return encoder.getVariableName(this);
        }
        Field<?> field = this.getField();
        FieldName name = field.getName();
        return IdentifierUtil.sanitize(name.getValue());
    }

    private String createMemberName() {
        Encoder encoder = this.getEncoder();
        if (encoder != null) {
            return encoder.getMemberName(this);
        }
        Field<?> field = this.getField();
        FieldName name = field.getName();
        return IdentifierUtil.sanitize(name.getValue());
    }
}

