/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.translator.JVarRef;

public class FieldValueRef
extends JVarRef {
    private DataType dataType = null;

    public FieldValueRef(JVar variable, DataType dataType) {
        super(variable);
        this.setDataType(dataType);
    }

    public JInvocation asJavaValue() {
        DataType dataType = this.getDataType();
        switch (dataType) {
            case STRING: {
                return this.asString();
            }
            case INTEGER: {
                return this.asInteger();
            }
            case FLOAT: {
                return this.asFloat();
            }
            case DOUBLE: {
                return this.asDouble();
            }
            case BOOLEAN: {
                return this.asBoolean();
            }
        }
        throw new IllegalArgumentException(dataType.toString());
    }

    public JInvocation asJavaPrimitiveValue() {
        DataType dataType = this.getDataType();
        switch (dataType) {
            case STRING: {
                return this.asString();
            }
            case INTEGER: {
                return this.asInteger().invoke("intValue");
            }
            case FLOAT: {
                return this.asFloat().invoke("floatValue");
            }
            case DOUBLE: {
                return this.asDouble().invoke("doubleValue");
            }
            case BOOLEAN: {
                return this.asBoolean().invoke("booleanValue");
            }
        }
        throw new IllegalArgumentException(dataType.toString());
    }

    public JInvocation asString() {
        return this.invoke("asString", new JExpression[0]);
    }

    public JInvocation asNumber() {
        return this.invoke("asNumber", new JExpression[0]);
    }

    public JInvocation asInteger() {
        return this.invoke("asInteger", new JExpression[0]);
    }

    public JInvocation asFloat() {
        return this.invoke("asFloat", new JExpression[0]);
    }

    public JInvocation asDouble() {
        return this.invoke("asDouble", new JExpression[0]);
    }

    public JInvocation asBoolean() {
        return this.invoke("asBoolean", new JExpression[0]);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }
}

