/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.fmt.JBinaryFile;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.jpmml.evaluator.ResourceUtil;
import org.jpmml.translator.JClassInitializer;
import org.jpmml.translator.TranslationContext;

public class JBinaryFileInitializer
extends JClassInitializer {
    private JBinaryFile binaryFile = null;
    private JVar dataInputVar = null;
    private JBlock tryBody = new JBlock();
    private JVar ioeVar = null;
    private JBlock catchBody = new JBlock();

    public JBinaryFileInitializer(String name, TranslationContext context) {
        this(name, -1, context);
    }

    public JBinaryFileInitializer(String name, int pos, TranslationContext context) {
        super(context);
        JBinaryFile binaryFile = new JBinaryFile(name);
        this.setBinaryFile(binaryFile);
        JDefinedClass owner = context.getOwner();
        JPackage _package = owner.getPackage();
        _package.addResourceFile((JResourceFile)binaryFile);
        JBlock resourceStmt = new JBlock(false, false);
        JClass dataInputStreamClazz = context.ref(DataInputStream.class);
        JInvocation isExpr = JExpr.dotclass((JClass)owner).invoke("getResourceAsStream").arg(name);
        this.dataInputVar = resourceStmt.decl((JType)dataInputStreamClazz, "dataInput", (JExpression)JExpr._new((JType)dataInputStreamClazz).arg((JExpression)isExpr));
        JBlock catchStmt = new JBlock(false, false);
        this.ioeVar = catchStmt.decl((JType)context.ref(IOException.class), "ioe");
        this.catchBody._throw((JExpression)context._new(ExceptionInInitializerError.class, this.ioeVar));
        JStatement tryWithResources = new JStatement(){

            public void state(JFormatter formatter) {
                formatter.p("try(").b(JBinaryFileInitializer.this.dataInputVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.tryBody);
                formatter.p("catch(").b(JBinaryFileInitializer.this.ioeVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.catchBody);
                formatter.nl();
            }
        };
        JBlock init = owner.init();
        if (pos > -1) {
            init.pos(pos);
        }
        init.add(tryWithResources);
    }

    @Override
    public void add(JStatement statement) {
        this.tryBody.add(statement);
    }

    public void initFieldNames(JFieldVar field, FieldName[] names) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeFieldNames((DataOutput)dataOutput, (FieldName[])names);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readFieldNames", this.dataInputVar, JExpr.lit((int)names.length));
        this.tryBody.assign((JAssignmentTarget)field, (JExpression)invocation);
    }

    public void initQNames(JFieldVar field, QName[] names) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeQNames((DataOutput)dataOutput, (QName[])names);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readQNames", this.dataInputVar, JExpr.lit((int)names.length));
        this.tryBody.assign((JAssignmentTarget)field, (JExpression)invocation);
    }

    public JFieldVar initStringLists(String name, List<String>[] stringLists) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createConstant(name, (JType)context.ref(List.class).narrow(String.class), context);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeStringLists((DataOutput)dataOutput, (List[])stringLists);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readStringLists", this.dataInputVar);
        this.add((JStatement)context.staticInvoke(Collections.class, "addAll", constant, invocation));
        return constant;
    }

    /*
     * Unable to fully structure code
     */
    public JFieldVar initNumbers(String name, MathContext mathContext, Number[] values) {
        context = this.getContext();
        binaryFile = this.getBinaryFile();
        constant = JBinaryFileInitializer.createConstant(name, (JType)context.ref(Number.class), context);
        try {
            os = binaryFile.getDataStore();
            var8_9 = null;
            try {
                dataOutput = new DataOutputStream(os);
                switch (2.$SwitchMap$org$dmg$pmml$MathContext[mathContext.ordinal()]) {
                    case 1: {
                        ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])values);
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])values);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (Throwable var9_12) {
                var8_9 = var9_12;
                throw var9_12;
            }
            finally {
                if (os != null) {
                    if (var8_9 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var9_11) {
                            var8_9.addSuppressed(var9_11);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumbers(mathContext), new Object[]{this.dataInputVar, JExpr.lit((int)values.length)});
        this.add((JStatement)context.staticInvoke(Collections.class, "addAll", new Object[]{constant, invocation}));
        return constant;
    }

    public JFieldVar initNumbersList(String name, MathContext mathContext, List<Number[]> elements) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createConstant(name, (JType)context.ref(Number[].class), context);
        JType intType = context._ref(Integer.TYPE);
        JArray countArray = JExpr.newArray((JType)intType);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Number[] element : elements) {
                switch (mathContext) {
                    case FLOAT: {
                        ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])element);
                        break;
                    }
                    case DOUBLE: {
                        ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])element);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                countArray.add(JExpr.lit((int)element.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod initMethod = JBinaryFileInitializer.createMethod(name, context)._throws(IOException.class);
        JVar dataInputParam = initMethod.param(DataInputStream.class, "dataInput");
        JBlock block = initMethod.body();
        JVar countsVar = block.decl((JType)intType.array(), "counts", (JExpression)countArray);
        JForEach forEach = block.forEach(intType, "count", (JExpression)countsVar);
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumbers(mathContext), dataInputParam, forEach.var());
        forEach.body().add((JStatement)constant.invoke("add").arg((JExpression)invocation));
        this.add((JStatement)JExpr.invoke((JMethod)initMethod).arg((JExpression)this.dataInputVar));
        return constant;
    }

    public JFieldVar initNumberArraysList(String name, MathContext mathContext, List<Number[][]> elements, int length) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        JFieldVar constant = JBinaryFileInitializer.createConstant(name, (JType)context.ref(Number[][].class), context);
        JType intType = context._ref(Integer.TYPE);
        JArray countArray = JExpr.newArray((JType)intType);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Number[][] element : elements) {
                switch (mathContext) {
                    case FLOAT: {
                        ResourceUtil.writeFloatArrays((DataOutput)dataOutput, (Number[][])element);
                        break;
                    }
                    case DOUBLE: {
                        ResourceUtil.writeDoubleArrays((DataOutput)dataOutput, (Number[][])element);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                countArray.add(JExpr.lit((int)element.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod initMethod = JBinaryFileInitializer.createMethod(name, context)._throws(IOException.class);
        JVar dataInputParam = initMethod.param(DataInputStream.class, "dataInput");
        JBlock block = initMethod.body();
        JVar countsVar = block.decl((JType)intType.array(), "counts", (JExpression)countArray);
        JForEach forEach = block.forEach(intType, "count", (JExpression)countsVar);
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, JBinaryFileInitializer.readNumberArrays(mathContext), dataInputParam, forEach.var(), JExpr.lit((int)length));
        forEach.body().add((JStatement)constant.invoke("add").arg((JExpression)invocation));
        this.add((JStatement)JExpr.invoke((JMethod)initMethod).arg((JExpression)this.dataInputVar));
        return constant;
    }

    public JBinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    private void setBinaryFile(JBinaryFile binaryFile) {
        this.binaryFile = binaryFile;
    }

    private static String readNumbers(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return "readFloats";
            }
            case DOUBLE: {
                return "readDoubles";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String readNumberArrays(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return "readFloatArrays";
            }
            case DOUBLE: {
                return "readDoubleArrays";
            }
        }
        throw new IllegalArgumentException();
    }
}

