/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.java.JavaModel;
import org.jpmml.model.visitors.ActiveFieldFinder;
import org.jpmml.model.visitors.FieldResolver;
import org.jpmml.translator.ClassificationBuilder;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.FunctionInvocationContext;
import org.jpmml.translator.FunctionInvocationUtil;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.JWrappedExpression;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.TranslatedModel;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.ValueBuilder;

public abstract class ModelTranslator<M extends Model>
extends ModelManager<M> {
    public static final int MEMBER_PUBLIC = 25;
    public static final int MEMBER_PRIVATE = 28;

    public ModelTranslator(PMML pmml, M model) {
        super(pmml, model);
        MathContext mathContext = model.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException(model, (Enum)mathContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JExpression translate(TranslationContext context) {
        Model model = this.getModel();
        JDefinedClass javaModelClazz = PMMLObjectUtil.createMemberClass(25, IdentifierUtil.create(JavaModel.class.getSimpleName(), (PMMLObject)model), context);
        javaModelClazz._extends(JavaModel.class);
        Set<FieldName> activeFieldNames = context.getActiveFieldNames();
        activeFieldNames.clear();
        try {
            context.pushOwner(javaModelClazz);
            this.createEvaluateMethod(context);
        }
        finally {
            context.popOwner();
        }
        JWrappedExpression expression = new JWrappedExpression((JExpression)JExpr._new((JClass)javaModelClazz));
        TranslatedModel translatedModel = new TranslatedModel(model).setExpression(expression).setActiveFields(new LinkedHashSet<FieldName>(activeFieldNames));
        context.addTranslation(model, translatedModel);
        return expression;
    }

    public void createEvaluateMethod(TranslationContext context) {
        Model model = this.getModel();
        MiningFunction miningFunction = model.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                JMethod regressorMethod = this.translateRegressor(context);
                this.createEvaluateRegressionMethod(regressorMethod, context);
                break;
            }
            case CLASSIFICATION: {
                JMethod classifierMethod = this.translateClassifier(context);
                this.createEvaluateClassificationMethod(classifierMethod, context);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum)miningFunction);
            }
        }
    }

    public JMethod translateRegressor(TranslationContext context) {
        throw new UnsupportedOperationException();
    }

    public JMethod translateClassifier(TranslationContext context) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMethod createEvaluateRegressionMethod(JMethod evaluateMethod, TranslationContext context) {
        Model model = this.getModel();
        TargetField targetField = this.getTargetField();
        JMethod evaluateRegressionMethod = ModelTranslator.createEvaluatorMethod("evaluateRegression", context);
        try {
            context.pushScope(new MethodScope(evaluateRegressionMethod));
            JInvocation methodInvocation = ModelTranslator.createEvaluatorMethodInvocation(evaluateMethod, context);
            JClass valueClazz = context.ref(Value.class);
            if (!evaluateMethod.type().erasure().equals(valueClazz)) {
                methodInvocation = context.getValueFactoryVariable().newValue((JExpression)methodInvocation);
            }
            ValueBuilder valueBuilder = new ValueBuilder(context).declare("value", methodInvocation);
            Target target = targetField.getTarget();
            if (target != null) {
                ModelTranslator.translateRegressorTarget(target, valueBuilder);
                model.setTargets(null);
            }
            JVar valueVar = valueBuilder.getVariable();
            context._return((JExpression)context.staticInvoke(Collections.class, "singletonMap", targetField.getName(), valueVar.invoke("getValue")));
        }
        finally {
            context.popScope();
        }
        return evaluateRegressionMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMethod createEvaluateClassificationMethod(JMethod evaluateMethod, TranslationContext context) {
        Model model = this.getModel();
        TargetField targetField = this.getTargetField();
        JMethod evaluateClassificationMethod = ModelTranslator.createEvaluatorMethod("evaluateClassification", context);
        try {
            context.pushScope(new MethodScope(evaluateClassificationMethod));
            ClassificationBuilder classificationBuilder = new ClassificationBuilder(context).declare("classification", (JExpression)ModelTranslator.createEvaluatorMethodInvocation(evaluateMethod, context)).computeResult(targetField.getDataType());
            context._return((JExpression)context.staticInvoke(Collections.class, "singletonMap", context.constantFieldName(targetField.getName()), classificationBuilder));
        }
        finally {
            context.popScope();
        }
        return evaluateClassificationMethod;
    }

    public Map<FieldName, FieldInfo> getFieldInfos(final Set<? extends PMMLObject> bodyObjects) {
        PMML pmml = this.getPMML();
        Model model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        Output output = model.getOutput();
        final HashMap bodyFields = new HashMap();
        FieldResolver fieldResolver = new FieldResolver(){

            public VisitorAction visit(PMMLObject object) {
                if (bodyObjects.contains(object)) {
                    Model parent = (Model)this.getParent();
                    Collection fields = this.getFields();
                    for (Field field : fields) {
                        FieldName name = field.getName();
                        Field previousField = bodyFields.put(name, field);
                        if (previousField == null || previousField == field) continue;
                        throw new IllegalArgumentException(name.getValue());
                    }
                    return VisitorAction.SKIP;
                }
                return super.visit(object);
            }
        };
        fieldResolver.applyTo((Visitable)pmml);
        Set names = ActiveFieldFinder.getFieldNames((PMMLObject[])bodyObjects.toArray(new PMMLObject[bodyObjects.size()]));
        LinkedHashMap<FieldName, FieldInfo> result = new LinkedHashMap<FieldName, FieldInfo>();
        for (FieldName name : names) {
            Field field = (Field)bodyFields.get(name);
            FieldInfo fieldInfo = new FieldInfo(field);
            result.put(name, fieldInfo);
        }
        FunctionInvocationContext context = new FunctionInvocationContext(){

            @Override
            public DefineFunction getDefineFunction(String name) {
                return ModelTranslator.this.getDefineFunction(name);
            }
        };
        ArrayList fieldInfos = new ArrayList(result.values());
        for (FieldInfo fieldInfo : fieldInfos) {
            ModelTranslator.enhanceFieldInfo(fieldInfo, miningSchema, bodyFields, result, context);
        }
        return result;
    }

    public Object[] getTargetCategories() {
        TargetField targetField = this.getTargetField();
        List categories = targetField.getCategories();
        return categories.toArray(new Object[categories.size()]);
    }

    public static <V extends Number> ValueFactory<V> getValueFactory(Model model) {
        MathContext mathContext = model.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                ValueFactoryFactory valueFactoryFactory = ValueFactoryFactory.newInstance();
                return valueFactoryFactory.newValueFactory(mathContext);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)model, (Enum)mathContext);
    }

    public static FieldInfo getFieldInfo(HasFieldReference<?> hasFieldReference, Map<FieldName, FieldInfo> fieldInfos) {
        return ModelTranslator.getFieldInfo(hasFieldReference.getField(), fieldInfos);
    }

    public static FieldInfo getFieldInfo(FieldName name, Map<FieldName, FieldInfo> fieldInfos) {
        FieldInfo fieldInfo = fieldInfos.get(name);
        if (fieldInfo == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        return fieldInfo;
    }

    private static void translateRegressorTarget(Target target, ValueBuilder valueBuilder) {
        Target.CastInteger castInteger;
        Number rescaleConstant;
        Number rescaleFactor = target.getRescaleFactor();
        if (rescaleFactor != null && rescaleFactor.doubleValue() != 1.0) {
            valueBuilder.update("multiply", rescaleFactor);
        }
        if ((rescaleConstant = target.getRescaleConstant()) != null && rescaleConstant.doubleValue() != 0.0) {
            valueBuilder.update("add", rescaleConstant);
        }
        if ((castInteger = target.getCastInteger()) != null) {
            throw new UnsupportedAttributeException((PMMLObject)target, (Enum)castInteger);
        }
    }

    public static JMethod createEvaluatorMethod(String name, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        JMethod method = owner.method(1, (JType)context.ref(Map.class).narrow(Arrays.asList(context.ref(FieldName.class), context.ref(Object.class).wildcard())), name);
        method.annotate(Override.class);
        JTypeVar numberTypeVar = method.generify("V", Number.class);
        method.param((JType)context.ref(ValueFactory.class).narrow((JClass)numberTypeVar), "valueFactory");
        method.param(EvaluationContext.class, "context");
        return method;
    }

    public static JMethod createEvaluatorMethod(Class<?> type, PMMLObject object, boolean withValueFactory, TranslationContext context) {
        return ModelTranslator.createEvaluatorMethod(type, IdentifierUtil.create("evaluate" + object.getClass().getSimpleName(), object), withValueFactory, context);
    }

    public static JMethod createEvaluatorMethod(Class<?> type, List<? extends PMMLObject> objects, boolean withValueFactory, TranslationContext context) {
        PMMLObject object = (PMMLObject)Iterables.getFirst(objects, null);
        return ModelTranslator.createEvaluatorMethod(type, IdentifierUtil.create("evaluate" + object.getClass().getSimpleName() + "List", object), withValueFactory, context);
    }

    private static JMethod createEvaluatorMethod(Class<?> type, String name, boolean withValueFactory, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        JMethod method = owner.method(28, type, name);
        if (withValueFactory) {
            JTypeVar numberTypeVar = method.generify("V", Number.class);
            TypeVariable<Class<?>>[] typeVariables = type.getTypeParameters();
            if (typeVariables.length == 1) {
                method.type((JType)context.ref(type).narrow((JClass)numberTypeVar));
            } else if (typeVariables.length == 2) {
                method.type((JType)context.ref(type).narrow(new JClass[]{context.ref(Object.class), numberTypeVar}));
            }
            method.param((JType)context.ref(ValueFactory.class).narrow((JClass)numberTypeVar), "valueFactory");
        }
        method.param((JType)ModelTranslator.ensureArgumentsType(context), "arguments");
        return method;
    }

    public static JInvocation createEvaluatorMethodInvocation(JMethod method, TranslationContext context) {
        JInvocation invocation = JExpr.invoke((JMethod)method);
        List params = method.params();
        for (JVar param : params) {
            JVar arg;
            String name;
            switch (name = param.name()) {
                case "arguments": {
                    try {
                        arg = context.getArgumentsVariable().getVariable();
                    }
                    catch (IllegalArgumentException iae) {
                        arg = JExpr._new((JClass)ModelTranslator.ensureArgumentsType(context)).arg((JExpression)context.getContextVariable().getVariable());
                    }
                    break;
                }
                case "context": {
                    arg = context.getContextVariable().getVariable();
                    break;
                }
                case "valueFactory": {
                    arg = context.getValueFactoryVariable().getVariable();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name);
                }
            }
            invocation = invocation.arg((JExpression)arg);
        }
        return invocation;
    }

    public static JDefinedClass ensureArgumentsType(TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        Iterator it = owner.classes();
        while (it.hasNext()) {
            JDefinedClass clazz = (JDefinedClass)it.next();
            if (!"Arguments".equals(clazz.name())) continue;
            return clazz;
        }
        JDefinedClass argumentsClazz = PMMLObjectUtil.createMemberClass(25, "Arguments", context);
        JFieldVar contextVar = argumentsClazz.field(4, EvaluationContext.class, "context");
        JMethod constructor = argumentsClazz.constructor(1);
        JVar contextParam = constructor.param(EvaluationContext.class, "context");
        JBlock block = constructor.body();
        block.assign((JAssignmentTarget)JExpr.refthis((String)contextVar.name()), (JExpression)contextParam);
        return argumentsClazz;
    }

    private static void enhanceFieldInfo(FieldInfo fieldInfo, MiningSchema miningSchema, Map<FieldName, Field<?>> bodyFields, Map<FieldName, FieldInfo> fieldInfos, FunctionInvocationContext context) {
        Field<?> field = fieldInfo.getField();
        if (field instanceof DerivedField) {
            DerivedField derivedField = (DerivedField)field;
            Expression expression = derivedField.getExpression();
            FunctionInvocation functionInvocation = FunctionInvocationUtil.match(expression, context);
            if (functionInvocation instanceof FunctionInvocation.Ref) {
                FunctionInvocation.Ref ref = (FunctionInvocation.Ref)functionInvocation;
                FieldName name = ref.getField();
                FieldInfo refFieldInfo = fieldInfos.get(name);
                if (refFieldInfo == null) {
                    Field<?> refField = bodyFields.get(name);
                    refFieldInfo = new FieldInfo(refField);
                    fieldInfos.put(name, refFieldInfo);
                    if (refField instanceof DataField) {
                        ModelTranslator.ensureActive(refField, miningSchema);
                    }
                    ModelTranslator.enhanceFieldInfo(refFieldInfo, miningSchema, bodyFields, fieldInfos, context);
                }
                fieldInfo.setRef(refFieldInfo);
                functionInvocation = null;
            }
            fieldInfo.setFunctionInvocation(functionInvocation);
        }
    }

    private static void ensureActive(Field<?> field, MiningSchema miningSchema) {
        FieldName name = field.getName();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                if (!miningField.getName().equals((Object)name)) continue;
                return;
            }
        }
        MiningField miningField = new MiningField(name);
        miningSchema.addMiningFields(new MiningField[]{miningField});
    }
}

