/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.jpmml.translator.OperableRef;
import org.jpmml.translator.TranslationContext;

public class PrimitiveRef
extends OperableRef {
    public PrimitiveRef(JVar variable) {
        super(variable);
        JType type = variable.type();
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException(type.fullName());
        }
    }

    @Override
    public JExpression isMissing() {
        return JExpr.FALSE;
    }

    @Override
    public JExpression isNotMissing() {
        return JExpr.TRUE;
    }

    @Override
    public JExpression equalTo(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.eq(this.literal(value, context));
    }

    @Override
    public JExpression notEqualTo(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.ne(this.literal(value, context));
    }

    @Override
    public JExpression lessThan(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.lt(this.literal(value, context));
    }

    @Override
    public JExpression lessOrEqual(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.lte(this.literal(value, context));
    }

    @Override
    public JExpression greaterOrEqual(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.gte(this.literal(value, context));
    }

    @Override
    public JExpression greaterThan(Object value, TranslationContext context) {
        JVar variable = this.getVariable();
        return variable.gt(this.literal(value, context));
    }
}

