/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;

public class DiscreteValueFinder
extends AbstractVisitor {
    private Map<FieldName, Set<Object>> fieldValues = new LinkedHashMap<FieldName, Set<Object>>();

    public VisitorAction visit(SimplePredicate simplePredicate) {
        FieldName name = simplePredicate.getField();
        SimplePredicate.Operator operator = simplePredicate.getOperator();
        Object value = simplePredicate.getValue();
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.addValue(name, value);
                break;
            }
        }
        return super.visit(simplePredicate);
    }

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        FieldName name = simpleSetPredicate.getField();
        SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.getBooleanOperator();
        ComplexArray array = (ComplexArray)simpleSetPredicate.getArray();
        Collection values = array.getValue();
        switch (booleanOperator) {
            case IS_IN: 
            case IS_NOT_IN: {
                for (Object value : values) {
                    this.addValue(name, value);
                }
                break;
            }
        }
        return super.visit(simpleSetPredicate);
    }

    public void addValue(FieldName name, Object value) {
        Map<FieldName, Set<Object>> fieldValues = this.getFieldValues();
        Set<Object> values = fieldValues.get(name);
        if (values == null) {
            values = new LinkedHashSet<Object>();
            fieldValues.put(name, values);
        }
        values.add(value);
    }

    public Map<FieldName, Set<Object>> getFieldValues() {
        return this.fieldValues;
    }
}

