/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.translator.ArrayManager;
import org.jpmml.translator.tree.ScoreFunction;

public abstract class NodeScoreDistributionManager<V extends Number>
extends ArrayManager<List<Number>>
implements ScoreFunction<List<Number>> {
    private Object[] categories = null;

    public NodeScoreDistributionManager(JType componentType, String name, Object[] categories) {
        super(componentType, name);
        this.setCategories(categories);
    }

    public abstract ValueFactory<V> getValueFactory();

    @Override
    public List<Number> apply(Node node) {
        Value value;
        Object category;
        ValueFactory<V> valueFactory = this.getValueFactory();
        if (!node.hasScoreDistributions()) {
            return null;
        }
        ValueMap probabilityMap = new ValueMap();
        List scoreDistributions = node.getScoreDistributions();
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            Number recordCount = scoreDistribution.getRecordCount();
            if (recordCount == null) {
                throw new MissingAttributeException((PMMLObject)node, PMMLAttributes.COMPLEXNODE_RECORDCOUNT);
            }
            category = scoreDistribution.getValue();
            value = valueFactory.newValue(recordCount);
            probabilityMap.put(category, (Object)value);
        }
        ValueUtil.normalizeSimpleMax((Iterable)probabilityMap.values());
        ArrayList<Number> result = new ArrayList<Number>();
        Object[] categories = this.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            category = categories[i];
            value = (Value)probabilityMap.get(category);
            if (value == null) {
                value = valueFactory.newValue((Number)0.0);
            }
            result.add(value.getValue());
        }
        return result;
    }

    @Override
    public JExpression createExpression(List<Number> probabilities) {
        JType componentType = this.getComponentType();
        JArray array = JExpr.newArray((JType)componentType.elementType());
        for (Number probability : probabilities) {
            JExpression elementExpr;
            if (probability instanceof Float) {
                elementExpr = JExpr.lit((float)probability.floatValue());
            } else if (probability instanceof Double) {
                elementExpr = JExpr.lit((double)probability.doubleValue());
            } else {
                throw new IllegalArgumentException();
            }
            array = array.add(elementExpr);
        }
        return array;
    }

    public Number[][] getValues() {
        Collection elements = this.getElements();
        Number[][] result = (Number[][])elements.stream().map(element -> element.toArray(new Number[element.size()])).toArray(x$0 -> new Number[x$0][]);
        return result;
    }

    public Object[] getCategories() {
        return this.categories;
    }

    private void setCategories(Object[] categories) {
        this.categories = Objects.requireNonNull(categories);
    }
}

