/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;

public class Main {
    @Parameter(names={"--fmap-input"}, description="XGBoost feature map input file", required=true)
    private File fmapInput = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--learner-input", "--model-input"}, description="XGBoost learner input file", required=true)
    private File learnerInput = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File pmmlOutput = null;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            commander.usage();
            System.exit(-1);
        }
        if (main.help) {
            commander.usage();
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        FeatureMap featureMap;
        Learner learner;
        try (FileInputStream is = new FileInputStream(this.learnerInput);){
            learner = XGBoostUtil.loadLearner(is);
        }
        try (FileInputStream is = new FileInputStream(this.fmapInput);){
            featureMap = XGBoostUtil.loadFeatureMap(is);
        }
        PMML pmml = learner.encodePMML(featureMap);
        try (FileOutputStream os = new FileOutputStream(this.pmmlOutput);){
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
    }
}

