/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.xgboost.CategoricalFeature;
import org.jpmml.xgboost.ContinuousFeature;
import org.jpmml.xgboost.Feature;

public class FeatureMap {
    private List<Feature> features = new ArrayList<Feature>();
    private Map<String, DataField> dataFields = new LinkedHashMap<String, DataField>();

    public void load(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            this.load(new BufferedReader(reader));
        }
    }

    public void load(BufferedReader reader) throws IOException {
        String line;
        int i = 0;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            this.load(st.nextToken(), st.nextToken(), st.nextToken());
            ++i;
        }
    }

    public void load(String id, String name, String type) {
        Feature feature;
        DataField dataField;
        if (Integer.parseInt(id) != this.features.size()) {
            throw new IllegalArgumentException(id);
        }
        String value = null;
        if ("i".equals(type)) {
            int equals = name.indexOf(61);
            if (equals < 0) {
                throw new IllegalArgumentException(name);
            }
            value = name.substring(equals + 1);
            name = name.substring(0, equals);
        }
        if ((dataField = this.dataFields.get(name)) == null) {
            dataField = FeatureMap.createDataField(FieldName.create((String)name), type);
            this.dataFields.put(name, dataField);
        }
        if (value != null) {
            dataField.addValues(new Value[]{new Value(value)});
        }
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CATEGORICAL: {
                feature = new CategoricalFeature(dataField, value);
                break;
            }
            case CONTINUOUS: {
                feature = new ContinuousFeature(dataField);
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        this.features.add(feature);
    }

    public Feature getFeature(int index) {
        return this.features.get(index);
    }

    public List<DataField> getDataFields() {
        ArrayList<DataField> result = new ArrayList<DataField>(this.dataFields.values());
        return result;
    }

    private static DataField createDataField(FieldName name, String type) {
        switch (type) {
            case "i": {
                return new DataField(name, OpType.CATEGORICAL, DataType.STRING);
            }
            case "q": {
                return new DataField(name, OpType.CONTINUOUS, DataType.FLOAT);
            }
            case "int": {
                return new DataField(name, OpType.CONTINUOUS, DataType.INTEGER);
            }
        }
        throw new IllegalArgumentException(type);
    }
}

