/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;

public class FeatureMap {
    private Map<FieldName, DataField> dataFields = new LinkedHashMap<FieldName, DataField>();
    private List<Feature> features = new ArrayList<Feature>();

    public void load(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            this.load(new BufferedReader(reader));
        }
    }

    public void load(BufferedReader reader) throws IOException {
        String line;
        int i = 0;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            this.load(st.nextToken(), st.nextToken(), st.nextToken());
            ++i;
        }
    }

    public void load(String id, String name, String type) {
        if (Integer.parseInt(id) != this.features.size()) {
            throw new IllegalArgumentException(id);
        }
        String value = null;
        if ("i".equals(type)) {
            int equals = name.indexOf(61);
            if (equals < 0) {
                throw new IllegalArgumentException(name);
            }
            value = name.substring(equals + 1);
            name = name.substring(0, equals);
        }
        this.load(FieldName.create((String)name), value, type);
    }

    private void load(FieldName name, String value, String type) {
        ContinuousFeature feature;
        DataField dataField = this.dataFields.get(name);
        if (dataField == null) {
            dataField = FeatureMap.createDataField(name, type);
            this.dataFields.put(name, dataField);
        }
        if (value != null) {
            PMMLUtil.addValues((DataField)dataField, Collections.singletonList(value));
        }
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CATEGORICAL: {
                feature = new BinaryFeature(null, (TypeDefinitionField)dataField, value);
                break;
            }
            case CONTINUOUS: {
                feature = new ContinuousFeature(null, (TypeDefinitionField)dataField);
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        this.features.add((Feature)feature);
    }

    public void addMissingValue(String value) {
        if (value == null) {
            return;
        }
        Collection<DataField> dataFields = this.dataFields.values();
        for (DataField dataField : dataFields) {
            PMMLUtil.addValues((DataField)dataField, Collections.singletonList(value), (Value.Property)Value.Property.MISSING);
        }
    }

    public Map<FieldName, DataField> getDataFields() {
        return this.dataFields;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    private static DataField createDataField(FieldName name, String type) {
        switch (type) {
            case "i": {
                return new DataField(name, OpType.CATEGORICAL, DataType.STRING);
            }
            case "q": {
                return new DataField(name, OpType.CONTINUOUS, DataType.FLOAT);
            }
            case "int": {
                return new DataField(name, OpType.CONTINUOUS, DataType.INTEGER);
            }
        }
        throw new IllegalArgumentException(type);
    }
}

