/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.ObjFunction;
import org.jpmml.xgboost.PoissonRegression;
import org.jpmml.xgboost.XGBoostDataInput;

public class XGBoostUtil {
    private XGBoostUtil() {
    }

    public static Learner loadLearner(InputStream is) throws IOException {
        int eof;
        XGBoostDataInput input = new XGBoostDataInput(is);
        Learner learner = new Learner();
        learner.load(input);
        ObjFunction obj = learner.getObj();
        if (obj instanceof PoissonRegression) {
            try {
                String max_delta_step = input.readString();
            }
            catch (EOFException eof2) {
                // empty catch block
            }
        }
        if ((eof = is.read()) != -1) {
            throw new IOException();
        }
        return learner;
    }

    public static FeatureMap loadFeatureMap(InputStream is) throws IOException {
        FeatureMap featureMap = new FeatureMap();
        featureMap.load(is);
        return featureMap;
    }

    public static Schema toXGBoostSchema(Schema schema) {
        ArrayList<Object> xgbFeatures = new ArrayList<Object>();
        List features = schema.getFeatures();
        for (Feature feature : features) {
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                xgbFeatures.add(binaryFeature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            DataType dataType = continuousFeature.getDataType();
            switch (dataType) {
                case INTEGER: 
                case FLOAT: {
                    break;
                }
                case DOUBLE: {
                    continuousFeature = continuousFeature.toContinuousFeature(DataType.FLOAT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            xgbFeatures.add(continuousFeature);
        }
        Schema xgbSchema = new Schema(schema.getLabel(), xgbFeatures);
        return xgbSchema;
    }
}

