/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dmg.pmml.DataType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostDataInput;

public class XGBoostUtil {
    private XGBoostUtil() {
    }

    public static Learner loadLearner(InputStream is) throws IOException {
        XGBoostDataInput input = new XGBoostDataInput(is);
        Learner learner = new Learner();
        learner.load(input);
        int eof = is.read();
        if (eof != -1) {
            throw new IOException();
        }
        return learner;
    }

    public static FeatureMap loadFeatureMap(InputStream is) throws IOException {
        FeatureMap featureMap = new FeatureMap();
        Iterator<String> lines = XGBoostUtil.parseFeatureMap(is);
        int i = 0;
        while (lines.hasNext()) {
            String line = lines.next();
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            String id = st.nextToken();
            String name = st.nextToken();
            String type = st.nextToken();
            if (Integer.parseInt(id) != i) {
                throw new IllegalArgumentException(id);
            }
            featureMap.addEntry(name, type);
            ++i;
        }
        return featureMap;
    }

    public static Schema toXGBoostSchema(Schema schema) {
        Function<Feature, Feature> function = new Function<Feature, Feature>(){

            public Feature apply(Feature feature) {
                if (feature instanceof BinaryFeature) {
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    return binaryFeature;
                }
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                DataType dataType = continuousFeature.getDataType();
                switch (dataType) {
                    case INTEGER: 
                    case FLOAT: {
                        break;
                    }
                    case DOUBLE: {
                        continuousFeature = continuousFeature.toContinuousFeature(DataType.FLOAT);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return continuousFeature;
            }
        };
        return schema.toTransformedSchema((Function)function);
    }

    private static Iterator<String> parseFeatureMap(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }
}

