/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.ByteStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XGBoostDataInput
implements Closeable {
    private LittleEndianDataInputStream dis = null;
    private static final byte[] BINF_MAGIC = new byte[]{98, 105, 110, 102};

    public XGBoostDataInput(InputStream is) throws IOException {
        this.dis = new LittleEndianDataInputStream(XGBoostDataInput.init(new PushbackInputStream(is, 4)));
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public String readString() throws IOException {
        int length = (int)this.dis.readLong();
        byte[] buffer = new byte[length];
        ByteStreams.readFully((InputStream)this.dis, (byte[])buffer);
        return new String(buffer);
    }

    public Map<String, String> readStringMap() throws IOException {
        int length = (int)this.dis.readLong();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            result.put(this.readString(), this.readString());
        }
        return result;
    }

    public List<String> readStringList() throws IOException {
        int length = (int)this.dis.readLong();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            result.add(this.readString());
        }
        return result;
    }

    public void readReserved(int length) throws IOException {
        int[] buffer = new int[length];
        boolean empty = true;
        for (int i = 0; i < length; ++i) {
            int value;
            buffer[i] = value = this.dis.readInt();
            empty &= value == 0;
        }
        if (!empty) {
            throw new IOException("Expected " + length + "-element array of zeroes, got " + Arrays.toString(buffer));
        }
    }

    private static InputStream init(PushbackInputStream is) throws IOException {
        byte[] header = new byte[4];
        ByteStreams.readFully((InputStream)is, (byte[])header);
        if (!Arrays.equals(BINF_MAGIC, header)) {
            is.unread(header);
        }
        return is;
    }
}

