/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.SimpleNode;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.NodeStat;
import org.jpmml.xgboost.XGBoostDataInput;

public class RegTree {
    private int num_roots;
    private int num_nodes;
    private int num_deleted;
    private int max_depth;
    private int num_feature;
    private int size_leaf_vector;
    private List<Node> nodes;
    private List<NodeStat> stats;

    public void load(XGBoostDataInput input) throws IOException {
        int i;
        this.num_roots = input.readInt();
        this.num_nodes = input.readInt();
        this.num_deleted = input.readInt();
        this.max_depth = input.readInt();
        this.num_feature = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(31);
        this.nodes = new ArrayList<Node>();
        for (i = 0; i < this.num_nodes; ++i) {
            Node node = new Node();
            node.load(input);
            this.nodes.add(node);
        }
        this.stats = new ArrayList<NodeStat>();
        for (i = 0; i < this.num_nodes; ++i) {
            NodeStat stat = new NodeStat();
            stat.load(input);
            this.stats.add(stat);
        }
    }

    public TreeModel encodeTreeModel(PredicateManager predicateManager, Schema schema) {
        org.dmg.pmml.tree.Node root = this.encodeNode((Predicate)new True(), predicateManager, 0, schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(TreeModel.MissingValueStrategy.DEFAULT_CHILD).setMathContext(MathContext.FLOAT);
        return treeModel;
    }

    private org.dmg.pmml.tree.Node encodeNode(Predicate predicate, PredicateManager predicateManager, int index, Schema schema) {
        String id = String.valueOf(index + 1);
        Node node = this.nodes.get(index);
        if (!node.is_leaf()) {
            boolean defaultLeft;
            Predicate rightPredicate;
            Predicate leftPredicate;
            int splitIndex = node.split_index();
            Feature feature = schema.getFeature(splitIndex);
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                String value = binaryFeature.getValue();
                leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.NOT_EQUAL, value);
                rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.EQUAL, value);
                defaultLeft = true;
            } else {
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                Number splitValue = Float.valueOf(Float.intBitsToFloat(node.split_cond()));
                DataType dataType = continuousFeature.getDataType();
                switch (dataType) {
                    case INTEGER: {
                        splitValue = (int)(((Number)splitValue).floatValue() + 1.0f);
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                String value = ValueUtil.formatValue((Number)splitValue);
                leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_THAN, value);
                rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_OR_EQUAL, value);
                defaultLeft = node.default_left();
            }
            org.dmg.pmml.tree.Node leftChild = this.encodeNode(leftPredicate, predicateManager, node.cleft(), schema);
            org.dmg.pmml.tree.Node rightChild = this.encodeNode(rightPredicate, predicateManager, node.cright(), schema);
            org.dmg.pmml.tree.Node result = ((org.dmg.pmml.tree.Node)new BranchNode().setId(id).setScore(null).setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId()).setPredicate(predicate)).addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
            return result;
        }
        float value = node.leaf_value();
        SimpleNode result = new LeafNode().setId(id).setScore((Object)Float.valueOf(value)).setPredicate(predicate);
        return result;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }
}

