/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.SimpleNode;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Loadable;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.NodeStat;
import org.jpmml.xgboost.XGBoostDataInput;

public class RegTree
implements Loadable {
    private int num_roots;
    private int num_nodes;
    private int num_deleted;
    private int max_depth;
    private int num_feature;
    private int size_leaf_vector;
    private Node[] nodes;
    private NodeStat[] stats;

    @Override
    public void load(XGBoostDataInput input) throws IOException {
        this.num_roots = input.readInt();
        this.num_nodes = input.readInt();
        this.num_deleted = input.readInt();
        this.max_depth = input.readInt();
        this.num_feature = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(31);
        this.nodes = (Node[])input.readObjectArray(Node.class, this.num_nodes);
        this.stats = (NodeStat[])input.readObjectArray(NodeStat.class, this.num_nodes);
    }

    public boolean isEmpty() {
        Node node = this.nodes[0];
        if (!node.is_leaf()) {
            return false;
        }
        Float value = Float.valueOf(node.leaf_value());
        return ValueUtil.isZero((Number)value);
    }

    public TreeModel encodeTreeModel(PredicateManager predicateManager, Schema schema) {
        org.dmg.pmml.tree.Node root = this.encodeNode((Predicate)True.INSTANCE, predicateManager, 0, schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(TreeModel.MissingValueStrategy.DEFAULT_CHILD).setMathContext(MathContext.FLOAT);
        return treeModel;
    }

    private org.dmg.pmml.tree.Node encodeNode(Predicate predicate, PredicateManager predicateManager, int index, Schema schema) {
        Integer id = index;
        Node node = this.nodes[index];
        if (!node.is_leaf()) {
            boolean defaultLeft;
            Predicate rightPredicate;
            Predicate leftPredicate;
            int splitIndex = node.split_index();
            Feature feature = schema.getFeature(splitIndex);
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                Object value = binaryFeature.getValue();
                leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.NOT_EQUAL, value);
                rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.EQUAL, value);
                defaultLeft = true;
            } else {
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                Number splitValue = Float.valueOf(Float.intBitsToFloat(node.split_cond()));
                DataType dataType = continuousFeature.getDataType();
                switch (dataType) {
                    case INTEGER: {
                        splitValue = (int)(((Number)splitValue).floatValue() + 1.0f);
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Expected integer or float data type, got " + dataType.value() + " data type");
                    }
                }
                leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_THAN, (Object)splitValue);
                rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_OR_EQUAL, (Object)splitValue);
                defaultLeft = node.default_left();
            }
            org.dmg.pmml.tree.Node leftChild = this.encodeNode(leftPredicate, predicateManager, node.cleft(), schema);
            org.dmg.pmml.tree.Node rightChild = this.encodeNode(rightPredicate, predicateManager, node.cright(), schema);
            org.dmg.pmml.tree.Node result = new BranchNode(null, predicate).setId((Object)id).setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId()).addNodes(leftChild, rightChild);
            return result;
        }
        Float value = Float.valueOf(node.leaf_value());
        SimpleNode result = new LeafNode((Object)value, predicate).setId((Object)id);
        return result;
    }
}

