/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.CharStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostDataInput;

public class XGBoostUtil {
    public static final String SERIALIZATION_HEADER = "CONFIG-offset:";
    public static final String BINF_HEADER = "binf";

    private XGBoostUtil() {
    }

    public static Learner loadLearner(InputStream is) throws IOException {
        return XGBoostUtil.loadLearner(is, ByteOrder.nativeOrder(), null);
    }

    public static Learner loadLearner(InputStream is, ByteOrder byteOrder, String charset) throws IOException {
        is = new BufferedInputStream(is, 16);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return XGBoostUtil.loadLearner(new DataInputStream(is), charset);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return XGBoostUtil.loadLearner(new LittleEndianDataInputStream(is), charset);
        }
        throw new IllegalArgumentException();
    }

    public static <DIS extends InputStream> Learner loadLearner(DIS is, String charset) throws IOException {
        int eof;
        long offset;
        if (!is.markSupported()) {
            throw new IllegalArgumentException();
        }
        boolean hasSerializationHeader = XGBoostUtil.consumeHeader(is, SERIALIZATION_HEADER);
        if (hasSerializationHeader && (offset = ((DataInput)((Object)is)).readLong()) < 0L) {
            throw new IOException();
        }
        boolean hasBInfHeader = XGBoostUtil.consumeHeader(is, BINF_HEADER);
        if (hasBInfHeader) {
            // empty if block
        }
        XGBoostDataInput input = new XGBoostDataInput(is, charset);
        Learner learner = new Learner();
        learner.load(input);
        if (!hasSerializationHeader && (eof = is.read()) != -1) {
            throw new IOException();
        }
        return learner;
    }

    public static FeatureMap loadFeatureMap(InputStream is) throws IOException {
        FeatureMap featureMap = new FeatureMap();
        Iterator<String> lines = XGBoostUtil.parseFeatureMap(is);
        int i = 0;
        while (lines.hasNext()) {
            String line = lines.next();
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            String id = st.nextToken();
            String name = st.nextToken();
            String type = st.nextToken();
            if (Integer.parseInt(id) != i) {
                throw new IllegalArgumentException(id);
            }
            featureMap.addEntry(name, type);
            ++i;
        }
        return featureMap;
    }

    private static Iterator<String> parseFeatureMap(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }

    private static <DIS extends InputStream> boolean consumeHeader(DIS is, String header) throws IOException {
        byte[] headerBytes = header.getBytes(StandardCharsets.UTF_8);
        byte[] buffer = new byte[headerBytes.length];
        is.mark(buffer.length);
        ((DataInput)((Object)is)).readFully(buffer);
        boolean equals = Arrays.equals(headerBytes, buffer);
        if (!equals) {
            is.reset();
        }
        return equals;
    }
}

