/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.SimpleNode;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BaseNFeature;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoryManager;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Loadable;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.NodeStat;
import org.jpmml.xgboost.XGBoostDataInput;

public class RegTree
implements Loadable {
    private int num_roots;
    private int num_nodes;
    private int num_deleted;
    private int max_depth;
    private int num_feature;
    private int size_leaf_vector;
    private Node[] nodes;
    private NodeStat[] stats;

    @Override
    public void load(XGBoostDataInput input) throws IOException {
        this.num_roots = input.readInt();
        this.num_nodes = input.readInt();
        this.num_deleted = input.readInt();
        this.max_depth = input.readInt();
        this.num_feature = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(31);
        this.nodes = (Node[])input.readObjectArray(Node.class, this.num_nodes);
        this.stats = (NodeStat[])input.readObjectArray(NodeStat.class, this.num_nodes);
    }

    public boolean isEmpty() {
        Node node = this.nodes[0];
        if (!node.is_leaf()) {
            return false;
        }
        Float value = Float.valueOf(node.leaf_value());
        return ValueUtil.isZero((Number)value);
    }

    public TreeModel encodeTreeModel(PredicateManager predicateManager, Schema schema) {
        org.dmg.pmml.tree.Node root = this.encodeNode(0, (org.dmg.pmml.Predicate)True.INSTANCE, new CategoryManager(), predicateManager, schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(TreeModel.MissingValueStrategy.DEFAULT_CHILD).setMathContext(MathContext.FLOAT);
        return treeModel;
    }

    private org.dmg.pmml.tree.Node encodeNode(int index, org.dmg.pmml.Predicate predicate, CategoryManager categoryManager, PredicateManager predicateManager, Schema schema) {
        Integer id = index;
        Node node = this.nodes[index];
        if (!node.is_leaf()) {
            boolean defaultLeft;
            org.dmg.pmml.Predicate rightPredicate;
            org.dmg.pmml.Predicate leftPredicate;
            int splitIndex = node.split_index();
            Feature feature = schema.getFeature(splitIndex);
            CategoryManager leftCategoryManager = categoryManager;
            CategoryManager rightCategoryManager = categoryManager;
            if (feature instanceof BaseNFeature) {
                BaseNFeature baseFeature = (BaseNFeature)feature;
                FieldName name = baseFeature.getName();
                int splitValue = (int)(Float.intBitsToFloat(node.split_cond()) + 1.0f);
                Predicate valueFilter = categoryManager.getValueFilter(name);
                List leftValues = baseFeature.getValues(base -> base < splitValue).stream().filter(valueFilter).collect(Collectors.toList());
                List rightValues = baseFeature.getValues(base -> base >= splitValue).stream().filter(valueFilter).collect(Collectors.toList());
                if (leftValues.size() == 0) {
                    throw new IllegalArgumentException("Left branch is not selectable");
                }
                if (rightValues.size() == 0) {
                    throw new IllegalArgumentException("Right branch is not selectable");
                }
                leftCategoryManager = leftCategoryManager.fork(name, leftValues);
                rightCategoryManager = rightCategoryManager.fork(name, rightValues);
                leftPredicate = predicateManager.createPredicate((Feature)baseFeature, leftValues);
                rightPredicate = predicateManager.createPredicate((Feature)baseFeature, rightValues);
                defaultLeft = node.default_left();
            } else if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                Object value = binaryFeature.getValue();
                leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.NOT_EQUAL, value);
                rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, SimplePredicate.Operator.EQUAL, value);
                defaultLeft = true;
            } else {
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                Number splitValue = Float.valueOf(Float.intBitsToFloat(node.split_cond()));
                DataType dataType = continuousFeature.getDataType();
                switch (dataType) {
                    case INTEGER: {
                        splitValue = (int)(((Number)splitValue).floatValue() + 1.0f);
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Expected integer or float data type for continuous feature " + continuousFeature.getName() + ", got " + dataType.value() + " data type");
                    }
                }
                leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_THAN, (Object)splitValue);
                rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_OR_EQUAL, (Object)splitValue);
                defaultLeft = node.default_left();
            }
            org.dmg.pmml.tree.Node leftChild = this.encodeNode(node.cleft(), leftPredicate, leftCategoryManager, predicateManager, schema);
            org.dmg.pmml.tree.Node rightChild = this.encodeNode(node.cright(), rightPredicate, rightCategoryManager, predicateManager, schema);
            org.dmg.pmml.tree.Node result = new BranchNode(null, predicate).setId((Object)id).setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId()).addNodes(leftChild, rightChild);
            return result;
        }
        Float value = Float.valueOf(node.leaf_value());
        SimpleNode result = new LeafNode((Object)value, predicate).setId((Object)id);
        return result;
    }
}

