/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.RegTree;

public abstract class ObjFunction {
    public abstract Label encodeLabel(FieldName var1, List<?> var2, PMMLEncoder var3);

    public abstract MiningModel encodeMiningModel(List<RegTree> var1, List<Float> var2, float var3, Integer var4, boolean var5, Schema var6);

    public float probToMargin(float value) {
        return value;
    }

    protected static MiningModel createMiningModel(List<RegTree> trees, List<Float> weights, float base_score, Integer ntreeLimit, boolean numeric, Schema schema) {
        Iterator<Float> weightIt;
        if (weights != null && trees.size() != weights.size()) {
            throw new IllegalArgumentException();
        }
        if (ntreeLimit != null) {
            if (ntreeLimit > trees.size()) {
                throw new IllegalArgumentException("Tree limit " + ntreeLimit + " is greater than the number of trees");
            }
            trees = trees.subList(0, ntreeLimit);
            if (weights != null) {
                weights = weights.subList(0, ntreeLimit);
            }
        }
        if (weights != null) {
            weights = new ArrayList<Float>(weights);
        }
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        boolean equalWeights = true;
        Iterator<RegTree> treeIt = trees.iterator();
        Iterator<Float> iterator = weightIt = weights != null ? weights.iterator() : null;
        while (treeIt.hasNext()) {
            Float weight;
            RegTree tree = treeIt.next();
            Float f = weight = weightIt != null ? weightIt.next() : null;
            if (tree.isEmpty()) {
                if (weightIt == null) continue;
                weightIt.remove();
                continue;
            }
            if (weight != null) {
                equalWeights &= ValueUtil.isOne((Number)weight);
            }
            TreeModel treeModel = tree.encodeTreeModel(numeric, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setMathContext(MathContext.FLOAT).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)(equalWeights ? Segmentation.MultipleModelMethod.SUM : Segmentation.MultipleModelMethod.WEIGHTED_SUM), treeModels, weights)).setTargets(ModelUtil.createRescaleTargets(null, (Number)Float.valueOf(base_score), (ContinuousLabel)continuousLabel));
        return miningModel;
    }

    protected static float inverseLogit(float value) {
        return (float)(-Math.log(1.0f / value - 1.0f));
    }

    protected static float inverseExp(float value) {
        return (float)Math.log(value);
    }
}

