/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.testing;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.testing.ModelEncoderBatchTest;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.FieldNameSet;
import org.jpmml.evaluator.FunctionNameStack;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.testing.ArchiveBatch;
import org.jpmml.evaluator.testing.CsvUtil;
import org.jpmml.evaluator.visitors.UnsupportedMarkupInspector;
import org.jpmml.model.visitors.InvalidMarkupInspector;
import org.jpmml.model.visitors.MissingMarkupInspector;
import org.jpmml.model.visitors.VisitorBattery;

public abstract class ModelEncoderBatch
extends ArchiveBatch {
    private Map<String, Object> options = new LinkedHashMap<String, Object>();

    public ModelEncoderBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract ModelEncoderBatchTest getArchiveBatchTest();

    public abstract PMML getPMML() throws Exception;

    public InputStream open(String path) throws IOException {
        ModelEncoderBatchTest batchTest = this.getArchiveBatchTest();
        Class<?> clazz = ((Object)((Object)batchTest)).getClass();
        InputStream result = clazz.getResourceAsStream(path);
        if (result == null) {
            throw new IOException(path);
        }
        return result;
    }

    protected List<Map<String, String>> loadRecords(String path) throws IOException {
        CsvUtil.Table table;
        String separator = this.getSeparator();
        try (InputStream is = this.open(path);){
            table = CsvUtil.readTable((InputStream)is, (String)separator);
        }
        Function<String, String> function = new Function<String, String>(){

            @Override
            public String apply(String string) {
                if ("N/A".equals(string) || "NA".equals(string)) {
                    return null;
                }
                return string;
            }
        };
        return CsvUtil.toRecords((CsvUtil.Table)table, (Function)function);
    }

    protected String getSeparator() {
        return ",";
    }

    public List<Map<String, Object>> getOptionsMatrix() {
        return Collections.singletonList(Collections.emptyMap());
    }

    public Evaluator getEvaluator() throws Exception {
        EvaluatorBuilder evaluatorBuilder = this.getEvaluatorBuilder();
        Evaluator evaluator = evaluatorBuilder.build();
        evaluator.verify();
        return evaluator;
    }

    public EvaluatorBuilder getEvaluatorBuilder() throws Exception {
        PMML pmml = this.getPMML();
        ModelEvaluatorBuilder evaluatorBuilder = new ModelEvaluatorBuilder(pmml);
        evaluatorBuilder.setDerivedFieldGuard((SymbolTable)new FieldNameSet(8)).setFunctionGuard((SymbolTable)new FunctionNameStack(4));
        return evaluatorBuilder;
    }

    public void validatePMML(PMML pmml) throws Exception {
        VisitorBattery visitorBattery = this.getValidators();
        if (visitorBattery != null && !visitorBattery.isEmpty()) {
            visitorBattery.applyTo((Visitable)pmml);
        }
    }

    public VisitorBattery getValidators() {
        VisitorBattery visitorBattery = new VisitorBattery();
        visitorBattery.add(MissingMarkupInspector.class);
        visitorBattery.add(InvalidMarkupInspector.class);
        visitorBattery.add(UnsupportedMarkupInspector.class);
        return visitorBattery;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    protected static String truncate(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return string.substring(0, i);
        }
        return string;
    }
}

