/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.testing;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OptionsUtil {
    private OptionsUtil() {
    }

    public static List<Map<String, Object>> generateOptionsMatrix(Map<String, Object> options) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Set<Map.Entry<String, Object>> entries = options.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                ArrayList<Map<String, Object>> arrayResult = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < array.length; ++i) {
                    arrayResult.addAll(OptionsUtil.extendOptions(result, key, array[i]));
                }
                result = arrayResult;
                continue;
            }
            result = OptionsUtil.extendOptions(result, key, value);
        }
        return result;
    }

    private static List<Map<String, Object>> extendOptions(List<Map<String, Object>> rows, String key, Object value) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (rows.isEmpty()) {
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            options.put(key, value);
            result.add(options);
        } else {
            for (Map<String, Object> row : rows) {
                LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>(row);
                options.put(key, value);
                result.add(options);
            }
        }
        return result;
    }
}

