/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.model.ToStringHelper;

public abstract class DiscreteLabel
extends ScalarLabel {
    private List<?> values = null;

    public DiscreteLabel(DataType dataType, List<?> values) {
        this(null, dataType, values);
    }

    public DiscreteLabel(String name, DataType dataType, List<?> values) {
        super(name, dataType);
        this.setValues(values);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DiscreteLabel) {
            DiscreteLabel that = (DiscreteLabel)object;
            return super.equals(object) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("values", this.getValues());
    }

    public int size() {
        List<?> values = this.getValues();
        return values.size();
    }

    public Object getValue(int index) {
        List<?> values = this.getValues();
        return values.get(index);
    }

    public List<?> getValues() {
        return this.values;
    }

    private void setValues(List<?> values) {
        if ((values = Objects.requireNonNull(values)).isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }
}

