/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class PercentileFunction
extends AbstractFunction {
    public PercentileFunction() {
        this(PercentileFunction.class.getName());
    }

    public PercentileFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkArguments(arguments, 2);
        Collection values = (Collection)FieldValueUtil.getValue(Collection.class, (FieldValue)arguments.get(0));
        int percentile = arguments.get(1).asInteger();
        if (percentile < 1 || percentile > 100) {
            throw new FunctionException((Function)this, "Invalid percentile value " + percentile + ". Must be greater than 0 and equal or less than 100");
        }
        Double result = PercentileFunction.evaluate(values, percentile);
        return FieldValueUtil.create((DataType)DataType.DOUBLE, (OpType)OpType.CONTINUOUS, (Object)result);
    }

    private static Double evaluate(Collection<?> values, int percentile) {
        ComplexDoubleVector doubleValues = new ComplexDoubleVector(values.size());
        for (Object value : values) {
            Double doubleValue = (Double)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            doubleValues.add(doubleValue.doubleValue());
        }
        return doubleValues.doublePercentile(percentile);
    }
}

