/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.model.ReflectionUtil;

@XmlRootElement(name="DataField")
public class RichDataField
extends DataField
implements HasParsedValueMapping<Value> {
    @XmlTransient
    private Map<FieldValue, Value> parsedValueMappings = null;

    public RichDataField() {
    }

    public RichDataField(DataField dataField) {
        ReflectionUtil.copyState((PMMLObject)dataField, (PMMLObject)this);
    }

    public Map<FieldValue, Value> getValueMapping() {
        return this.getValueMapping(this.getDataType(), this.getOpType());
    }

    public Map<FieldValue, Value> getValueMapping(DataType dataType, OpType opType) {
        if (this.parsedValueMappings == null) {
            this.parsedValueMappings = ImmutableMap.copyOf(this.parseValues(dataType, opType));
        }
        return this.parsedValueMappings;
    }

    private Map<FieldValue, Value> parseValues(DataType dataType, OpType opType) {
        LinkedHashMap<FieldValue, Value> result = new LinkedHashMap<FieldValue, Value>();
        List pmmlValues = this.getValues();
        block6: for (Value pmmlValue : pmmlValues) {
            String stringValue = pmmlValue.getValue();
            if (stringValue == null) {
                throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
            }
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    FieldValue value = this.parse(dataType, opType, stringValue);
                    result.put(value, pmmlValue);
                    continue block6;
                }
                case INVALID: 
                case MISSING: {
                    FieldValue value;
                    try {
                        value = this.parse(dataType, opType, stringValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block6;
                    }
                    result.put(value, pmmlValue);
                    continue block6;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
        }
        return result;
    }
}

