/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.spark;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.visitors.LocatorTransformer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Evaluator createEvaluator(File file) throws IOException, SAXException, JAXBException {
        try (FileInputStream is = new FileInputStream(file);){
            Evaluator evaluator = EvaluatorUtil.createEvaluator(is);
            return evaluator;
        }
    }

    public static Evaluator createEvaluator(InputStream is) throws SAXException, JAXBException {
        SAXSource source = ImportFilter.apply((InputSource)new InputSource(is));
        PMML pmml = JAXBUtil.unmarshalPMML((Source)source);
        LocatorTransformer locatorTransformer = new LocatorTransformer();
        locatorTransformer.applyTo((Visitable)pmml);
        ModelEvaluatorFactory modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        ModelEvaluator evaluator = modelEvaluatorFactory.newModelEvaluator(pmml);
        evaluator.verify();
        return evaluator;
    }
}

