/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.spark;

import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.spark.ColumnProducer;
import org.jpmml.evaluator.spark.SchemaUtil;

class TargetColumnProducer
extends ColumnProducer<TargetField> {
    TargetColumnProducer(TargetField field, String columnName) {
        super(field, columnName != null ? columnName : TargetColumnProducer.getName(field));
    }

    @Override
    public StructField init(Evaluator evaluator) {
        TargetField field = (TargetField)this.getField();
        DataType dataType = field.getDataType();
        return DataTypes.createStructField((String)this.getColumnName(), (org.apache.spark.sql.types.DataType)SchemaUtil.translateDataType(dataType), (boolean)false);
    }

    @Override
    public Object format(Object value) {
        return EvaluatorUtil.decode((Object)value);
    }

    private static String getName(TargetField field) {
        if (field.isSynthetic()) {
            return "_target";
        }
        return field.getName().getValue();
    }
}

