/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.Batch;
import org.jpmml.evaluator.testing.Conflict;

public class BatchUtil {
    private BatchUtil() {
    }

    public static List<Conflict> evaluate(Batch batch) throws Exception {
        Evaluator evaluator = batch.getEvaluator();
        List input = batch.getInput();
        List<Map<String, ?>> output = batch.getOutput();
        if (evaluator instanceof HasGroupFields) {
            HasGroupFields hasGroupFields = (HasGroupFields)evaluator;
            input = EvaluatorUtil.groupRows((HasGroupFields)hasGroupFields, input);
        }
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Expected the same number of data rows, got " + input.size() + " input data rows and " + output.size() + " expected output data rows");
        }
        Predicate<ResultField> columnFilter = batch.getColumnFilter();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        List targetFields = evaluator.getTargetFields();
        for (Object targetField : targetFields) {
            if (targetField.isSynthetic() || !columnFilter.test((ResultField)targetField)) continue;
            names.add(targetField.getName());
        }
        List outputFields = evaluator.getOutputFields();
        for (OutputField outputField : outputFields) {
            if (!columnFilter.test((ResultField)outputField)) continue;
            names.add(outputField.getName());
        }
        Equivalence<Object> equivalence = batch.getEquivalence();
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        for (int i = 0; i < input.size(); ++i) {
            Map arguments = (Map)input.get(i);
            Map expectedResults = output.get(i);
            expectedResults = Maps.filterKeys(expectedResults, names::contains);
            try {
                Map actualResults = evaluator.evaluate(arguments);
                actualResults = Maps.filterKeys((Map)actualResults, names::contains);
                MapDifference difference = Maps.difference((Map)expectedResults, (Map)actualResults, equivalence);
                if (difference.areEqual()) continue;
                Conflict conflict = new Conflict((Integer)i, arguments, difference);
                conflicts.add(conflict);
                continue;
            }
            catch (Exception e) {
                Conflict conflict = new Conflict((Integer)i, arguments, e);
                conflicts.add(conflict);
            }
        }
        return conflicts;
    }
}

