/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CsvUtil {
    private CsvUtil() {
    }

    public static Table readTable(InputStream is) throws IOException {
        return CsvUtil.readTable(is, null);
    }

    public static Table readTable(InputStream is, String separator) throws IOException {
        Table table = new Table();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String line;
            Splitter splitter = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("")) {
                    break;
                }
                if (separator == null) {
                    separator = CsvUtil.getSeparator(line);
                }
                if (splitter == null) {
                    splitter = Splitter.on((String)separator);
                }
                ArrayList row = Lists.newArrayList((Iterable)splitter.split((CharSequence)line));
                table.add(row);
            }
        }
        table.setSeparator(separator);
        return table;
    }

    public static void writeTable(Table table, OutputStream os) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));){
            Joiner joiner = Joiner.on((String)table.getSeparator());
            for (int i = 0; i < table.size(); ++i) {
                List row = (List)table.get(i);
                if (i > 0) {
                    writer.write(10);
                }
                writer.write(joiner.join((Iterable)row));
            }
        }
    }

    public static <V> List<Map<String, V>> toRecords(Table table, Function<String, V> parseFunction) {
        ArrayList<Map<String, V>> records = new ArrayList<Map<String, V>>(table.size() - 1);
        List headerRow = (List)table.get(0);
        LinkedHashSet uniqueHeaderRow = new LinkedHashSet(headerRow);
        if (uniqueHeaderRow.size() < headerRow.size()) {
            LinkedHashSet<String> duplicateHeaderCells = new LinkedHashSet<String>();
            for (int column = 0; column < headerRow.size(); ++column) {
                String headerCell = (String)headerRow.get(column);
                if (Collections.frequency(headerRow, headerCell) == 1) continue;
                duplicateHeaderCells.add(headerCell);
            }
            if (!duplicateHeaderCells.isEmpty()) {
                throw new IllegalArgumentException("Expected unique cell names, got non-unique cell name(s) " + duplicateHeaderCells);
            }
        }
        for (int row = 1; row < table.size(); ++row) {
            List bodyRow = (List)table.get(row);
            if (headerRow.size() != bodyRow.size()) {
                throw new IllegalArgumentException("Expected " + headerRow.size() + " cells, got " + bodyRow.size() + " cells (data record " + (row - 1) + ")");
            }
            LinkedHashMap<String, V> record = new LinkedHashMap<String, V>();
            for (int column = 0; column < headerRow.size(); ++column) {
                String fieldName = (String)headerRow.get(column);
                V value = parseFunction.apply((String)bodyRow.get(column));
                record.put(fieldName, value);
            }
            records.add(record);
        }
        return records;
    }

    public static Table fromRecords(String separator, List<String> fieldNames, List<? extends Map<String, ?>> records, Function<Object, String> formatFunction) {
        Table table = new Table(1 + records.size());
        table.setSeparator(separator);
        ArrayList<String> headerRow = new ArrayList<String>(fieldNames.size());
        for (String string : fieldNames) {
            headerRow.add(string != null ? string : "(null)");
        }
        table.add(headerRow);
        for (Map map : records) {
            ArrayList<String> bodyRow = new ArrayList<String>(fieldNames.size());
            for (String fieldName : fieldNames) {
                Object value = map.get(fieldName);
                bodyRow.add(formatFunction.apply(value));
            }
            table.add(bodyRow);
        }
        return table;
    }

    private static String getSeparator(String line) {
        String[] separators;
        for (String separator : separators = new String[]{"\t", ";", ","}) {
            String[] cells = line.split(separator);
            if (cells.length <= 1) continue;
            return separator;
        }
        throw new IllegalArgumentException("Missing CSV separator");
    }

    public static class Table
    extends ArrayList<List<String>> {
        private String separator = null;

        public Table() {
            this(1024);
        }

        public Table(int initialCapacity) {
            super(initialCapacity);
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }
    }
}

