/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Equivalence;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.TypeUtil;

public class RealNumberEquivalence
extends Equivalence<Object> {
    private int tolerance = 0;

    public RealNumberEquivalence(int tolerance) {
        this.setTolerance(tolerance);
    }

    public boolean doEquivalent(Object expected, Object actual) {
        int tolerance = this.getTolerance();
        if (actual instanceof Computable) {
            actual = EvaluatorUtil.decode((Object)actual);
        }
        if ((expected = TypeUtil.parseOrCast((DataType)TypeUtil.getDataType((Object)actual), (Object)expected)) instanceof Float && actual instanceof Float) {
            float actualValue;
            float expectedValue = ((Float)expected).floatValue();
            if (expectedValue == (actualValue = ((Float)actual).floatValue())) {
                return true;
            }
            float leftMargin = expectedValue - (float)tolerance * Math.ulp(expectedValue);
            float rightMargin = expectedValue + (float)tolerance * Math.ulp(expectedValue);
            return actualValue >= leftMargin && actualValue <= rightMargin;
        }
        if (expected instanceof Double && actual instanceof Double) {
            double actualValue;
            double expectedValue = (Double)expected;
            if (expectedValue == (actualValue = ((Double)actual).doubleValue())) {
                return true;
            }
            double leftMargin = expectedValue - (double)tolerance * Math.ulp(expectedValue);
            double rightMargin = expectedValue + (double)tolerance * Math.ulp(expectedValue);
            return actualValue >= leftMargin && actualValue <= rightMargin;
        }
        return Objects.equals(expected, actual);
    }

    public int doHash(Object object) {
        throw new UnsupportedOperationException();
    }

    public int getTolerance() {
        return this.tolerance;
    }

    private void setTolerance(int tolerance) {
        if (tolerance < 0) {
            throw new IllegalArgumentException();
        }
        this.tolerance = tolerance;
    }
}

