/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.FieldNameSet;
import org.jpmml.evaluator.FunctionNameStack;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.PMMLTransformer;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.testing.ArchiveBatch;
import org.jpmml.evaluator.testing.ArchiveBatchTest;

public abstract class SimpleArchiveBatch
extends ArchiveBatch {
    public SimpleArchiveBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract ArchiveBatchTest getArchiveBatchTest();

    @Override
    public InputStream open(String path) throws IOException {
        ArchiveBatchTest batchTest = this.getArchiveBatchTest();
        Class<?> clazz = batchTest.getClass();
        InputStream result = clazz.getResourceAsStream(path);
        if (result == null) {
            throw new IOException(path);
        }
        return result;
    }

    @Override
    public Evaluator getEvaluator() throws Exception {
        EvaluatorBuilder evaluatorBuilder = this.getEvaluatorBuilder();
        Evaluator evaluator = evaluatorBuilder.build();
        evaluator.verify();
        return evaluator;
    }

    public EvaluatorBuilder getEvaluatorBuilder() throws Exception {
        LoadingModelEvaluatorBuilder evaluatorBuilder = this.createLoadingModelEvaluatorBuilder();
        InputStream is = this.open(this.getPmmlPath());
        Object object = null;
        try {
            evaluatorBuilder.load(is);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        List<PMMLTransformer<?>> transformers = this.getTransformers();
        for (PMMLTransformer pMMLTransformer : transformers) {
            evaluatorBuilder.transform(pMMLTransformer);
        }
        return evaluatorBuilder;
    }

    public String getPmmlPath() {
        return "/pmml/" + this.getAlgorithm() + this.getDataset() + ".pmml";
    }

    protected LoadingModelEvaluatorBuilder createLoadingModelEvaluatorBuilder() {
        LoadingModelEvaluatorBuilder evaluatorBuilder = new LoadingModelEvaluatorBuilder();
        evaluatorBuilder.setDerivedFieldGuard((SymbolTable)new FieldNameSet(8)).setFunctionGuard((SymbolTable)new FunctionNameStack(4));
        return evaluatorBuilder;
    }

    protected List<PMMLTransformer<?>> getTransformers() {
        return Collections.emptyList();
    }
}

