/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.Batch;
import org.jpmml.evaluator.testing.CsvUtil;

public abstract class ArchiveBatch
implements Batch {
    private String algorithm = null;
    private String dataset = null;
    private Predicate<ResultField> columnFilter = null;
    private Equivalence<Object> equivalence = null;

    public ArchiveBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        this.setAlgorithm(algorithm);
        this.setDataset(dataset);
        this.setColumnFilter(columnFilter);
        this.setEquivalence(equivalence);
    }

    public abstract InputStream open(String var1) throws IOException;

    public String getInputCsvPath() {
        return "/csv/" + this.getDataset() + ".csv";
    }

    @Override
    public List<? extends Map<String, ?>> getInput() throws IOException {
        return this.loadRecords(this.getInputCsvPath());
    }

    public String getOutputCsvPath() {
        return "/csv/" + this.getAlgorithm() + this.getDataset() + ".csv";
    }

    @Override
    public List<? extends Map<String, ?>> getOutput() throws IOException {
        return this.loadRecords(this.getOutputCsvPath());
    }

    @Override
    public void close() throws Exception {
    }

    protected List<Map<String, String>> loadRecords(String path) throws IOException {
        CsvUtil.Table table;
        try (InputStream is = this.open(path);){
            table = CsvUtil.readTable(is, ",");
        }
        Function<String, String> function = new Function<String, String>(){

            @Override
            public String apply(String string) {
                if ("N/A".equals(string) || "NA".equals(string)) {
                    return null;
                }
                return string;
            }
        };
        return CsvUtil.toRecords(table, function);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private void setAlgorithm(String algorithm) {
        this.algorithm = Objects.requireNonNull(algorithm);
    }

    public String getDataset() {
        return this.dataset;
    }

    private void setDataset(String dataset) {
        this.dataset = Objects.requireNonNull(dataset);
    }

    @Override
    public Predicate<ResultField> getColumnFilter() {
        return this.columnFilter;
    }

    private void setColumnFilter(Predicate<ResultField> columnFilter) {
        this.columnFilter = Objects.requireNonNull(columnFilter);
    }

    @Override
    public Equivalence<Object> getEquivalence() {
        return this.equivalence;
    }

    private void setEquivalence(Equivalence<Object> equivalence) {
        this.equivalence = Objects.requireNonNull(equivalence);
    }
}

