/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.base.Equivalence;
import java.util.Objects;
import java.util.function.Predicate;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.ArchiveBatch;
import org.jpmml.evaluator.testing.BatchTest;

public abstract class ArchiveBatchTest
extends BatchTest {
    private Equivalence<Object> equivalence = null;

    public ArchiveBatchTest(Equivalence<Object> equivalence) {
        this.setEquivalence(equivalence);
    }

    public abstract ArchiveBatch createBatch(String var1, String var2, Predicate<ResultField> var3, Equivalence<Object> var4);

    public void evaluate(String algorithm, String dataset) throws Exception {
        this.evaluate(algorithm, dataset, null, null);
    }

    public void evaluate(String algorithm, String dataset, Predicate<ResultField> columnFilter) throws Exception {
        this.evaluate(algorithm, dataset, columnFilter, null);
    }

    public void evaluate(String algorithm, String dataset, Equivalence<Object> equivalence) throws Exception {
        this.evaluate(algorithm, dataset, null, equivalence);
    }

    public void evaluate(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) throws Exception {
        if (columnFilter == null) {
            columnFilter = resultField -> true;
        }
        if (equivalence == null) {
            equivalence = this.getEquivalence();
        }
        try (ArchiveBatch batch = this.createBatch(algorithm, dataset, columnFilter, equivalence);){
            this.evaluate(batch);
        }
    }

    public Equivalence<Object> getEquivalence() {
        return this.equivalence;
    }

    private void setEquivalence(Equivalence<Object> equivalence) {
        this.equivalence = Objects.requireNonNull(equivalence);
    }
}

