/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.Batch;
import org.jpmml.evaluator.testing.BatchUtil;
import org.jpmml.evaluator.testing.Conflict;
import org.junit.Assert;

public abstract class BatchTest {
    public void evaluate(Batch batch) throws Exception {
        List<Conflict> conflicts = BatchUtil.evaluate(batch);
        if (!conflicts.isEmpty()) {
            for (Conflict conflict : conflicts) {
                this.log(conflict);
            }
            Assert.fail((String)("Found " + conflicts.size() + " conflict(s)"));
        }
    }

    public void log(Conflict conflict) {
        System.err.println(conflict);
    }

    public static Predicate<ResultField> excludeFields(String ... names) {
        return BatchTest.excludeFields(new LinkedHashSet<String>(Arrays.asList(names)));
    }

    public static Predicate<ResultField> excludeFields(final Collection<String> names) {
        Predicate<ResultField> columnFilter = new Predicate<ResultField>(){

            @Override
            public boolean test(ResultField resultField) {
                return !names.contains(resultField.getName());
            }
        };
        return columnFilter;
    }
}

