/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.testing;

import com.google.common.collect.MapDifference;
import java.util.Map;
import org.jpmml.model.ToStringHelper;

public class Conflict {
    private Integer id = null;
    private Map<String, ?> arguments = null;
    private MapDifference<String, ?> difference = null;
    private Exception exception = null;

    public Conflict(Integer id, Map<String, ?> arguments, MapDifference<String, ?> difference) {
        this.setId(id);
        this.setArguments(arguments);
        this.setDifference(difference);
    }

    public Conflict(Integer id, Map<String, ?> arguments, Exception exception) {
        this.setId(id);
        this.setArguments(arguments);
        this.setException(exception);
    }

    public String toString() {
        Exception exception;
        ToStringHelper helper = new ToStringHelper((Object)this).add("id", (Object)this.getId()).add("arguments", this.getArguments());
        MapDifference<String, ?> difference = this.getDifference();
        if (difference != null) {
            Map differing;
            Map onlyOnRight;
            Map onlyOnLeft = difference.entriesOnlyOnLeft();
            if (!onlyOnLeft.isEmpty()) {
                helper.add("expected but absent", (Object)onlyOnLeft);
            }
            if (!(onlyOnRight = difference.entriesOnlyOnRight()).isEmpty()) {
                helper.add("not expected but present", (Object)onlyOnRight);
            }
            if (!(differing = difference.entriesDiffering()).isEmpty()) {
                helper.add("differing (expected vs. actual)", (Object)differing);
            }
        }
        if ((exception = this.getException()) != null) {
            helper.add("exception", (Object)exception);
        }
        return helper.toString();
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public Map<String, ?> getArguments() {
        return this.arguments;
    }

    private void setArguments(Map<String, ?> arguments) {
        this.arguments = arguments;
    }

    public MapDifference<String, ?> getDifference() {
        return this.difference;
    }

    private void setDifference(MapDifference<String, ?> difference) {
        this.difference = difference;
    }

    public Exception getException() {
        return this.exception;
    }

    private void setException(Exception exception) {
        this.exception = exception;
    }
}

