/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ArgumentUtil {
    private ArgumentUtil() {
    }

    public static FieldValue prepare(DataField dataField, MiningField miningField, Object value) {
        if (dataField == null) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        if (ArgumentUtil.isOutlier(dataField, value)) {
            if (miningField == null) {
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
            OutlierTreatmentMethodType outlierTreatmentMethod = miningField.getOutlierTreatment();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    break;
                }
                case AS_MISSING_VALUES: {
                    value = null;
                    break;
                }
                case AS_EXTREME_VALUES: {
                    Double lowValue = miningField.getLowValue();
                    Double highValue = miningField.getHighValue();
                    if (lowValue == null || highValue == null) {
                        throw new InvalidFeatureException((PMMLObject)miningField);
                    }
                    Double doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                    if (TypeUtil.compare(DataType.DOUBLE, doubleValue, lowValue) < 0) {
                        value = lowValue;
                        break;
                    }
                    if (TypeUtil.compare(DataType.DOUBLE, doubleValue, highValue) <= 0) break;
                    value = highValue;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum)outlierTreatmentMethod);
                }
            }
        }
        if (ArgumentUtil.isMissing(dataField, value)) {
            if (miningField == null) {
                return null;
            }
            value = miningField.getMissingValueReplacement();
            if (value == null) {
                return null;
            }
        }
        if (ArgumentUtil.isInvalid(dataField, value)) {
            if (miningField == null) {
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException((PMMLObject)miningField);
                }
                case AS_IS: {
                    break;
                }
                case AS_MISSING: {
                    value = miningField.getMissingValueReplacement();
                    if (value != null) break;
                    return null;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum)invalidValueTreatmentMethod);
                }
            }
        }
        return FieldValueUtil.create((Field)dataField, value);
    }

    public static boolean isOutlier(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double minValue;
                ArrayList range = null;
                List fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    if (range == null) {
                        range = Lists.newArrayList();
                    }
                    range.add(fieldInterval.getLeftMargin());
                    range.add(fieldInterval.getRightMargin());
                }
                List fieldValues = dataField.getValues();
                for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            if (range == null) {
                                range = Lists.newArrayList();
                            }
                            range.add((Double)TypeUtil.parseOrCast(DataType.DOUBLE, fieldValue.getValue()));
                            break;
                        }
                    }
                }
                if (range == null) {
                    return false;
                }
                Double doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                if (TypeUtil.compare(DataType.DOUBLE, doubleValue, minValue = (Double)Collections.min(range)) < 0) {
                    return true;
                }
                Double maxValue = (Double)Collections.max(range);
                if (TypeUtil.compare(DataType.DOUBLE, doubleValue, maxValue) <= 0) break;
                return true;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
            }
        }
        return false;
    }

    public static boolean isMissing(DataField dataField, Object value) {
        if (value == null) {
            return true;
        }
        String stringValue = TypeUtil.format(value);
        List fieldValues = dataField.getValues();
        block3: for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case MISSING: {
                    boolean equals = TypeUtil.equals(DataType.STRING, stringValue, fieldValue.getValue());
                    if (!equals) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInvalid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        return !ArgumentUtil.isValid(dataField, value);
    }

    public static boolean isValid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        DataType dataType = dataField.getDataType();
        value = TypeUtil.parseOrCast(dataType, value);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double doubleValue = (Double)TypeUtil.cast(DataType.DOUBLE, value);
                int intervalCount = 0;
                List fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    ++intervalCount;
                    if (!DiscretizationUtil.contains(fieldInterval, doubleValue)) continue;
                    return true;
                }
                if (intervalCount > 0) {
                    return false;
                }
            }
            case CATEGORICAL: 
            case ORDINAL: {
                int validValueCount = 0;
                List fieldValues = dataField.getValues();
                block10: for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            ++validValueCount;
                            boolean equals = TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, fieldValue.getValue()));
                            if (!equals) continue block10;
                            return true;
                        }
                        case INVALID: {
                            boolean equals = TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, fieldValue.getValue()));
                            if (!equals) continue block10;
                            return false;
                        }
                        case MISSING: {
                            break;
                        }
                        default: {
                            throw new UnsupportedFeatureException((PMMLObject)fieldValue, (Enum)property);
                        }
                    }
                }
                return validValueCount <= 0;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
            }
        }
    }

    public static List<String> getValidValues(TypeDefinitionField field) {
        List fieldValues = field.getValues();
        if (fieldValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case VALID: {
                    result.add(fieldValue.getValue());
                    break;
                }
            }
        }
        return result;
    }
}

