/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.jpmml.evaluator.Association;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class AssociationModelEvaluator
extends ModelEvaluator<AssociationModel>
implements HasEntityRegistry<AssociationRule> {
    private static final LoadingCache<AssociationModel, BiMap<String, AssociationRule>> entityCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<AssociationModel, BiMap<String, AssociationRule>>(){

        public BiMap<String, AssociationRule> load(AssociationModel associationModel) {
            HashBiMap result = HashBiMap.create();
            EntityUtil.putAll(associationModel.getAssociationRules(), result);
            return result;
        }
    });
    private static final LoadingCache<AssociationModel, BiMap<String, Item>> itemCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<AssociationModel, BiMap<String, Item>>(){

        public BiMap<String, Item> load(AssociationModel associationModel) {
            HashBiMap result = HashBiMap.create();
            EntityUtil.putAll(associationModel.getItems(), result);
            return result;
        }
    });
    private static final LoadingCache<AssociationModel, BiMap<String, Itemset>> itemsetCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<AssociationModel, BiMap<String, Itemset>>(){

        public BiMap<String, Itemset> load(AssociationModel associationModel) {
            HashBiMap result = HashBiMap.create();
            EntityUtil.putAll(associationModel.getItemsets(), result);
            return result;
        }
    });
    private static final LoadingCache<AssociationModel, BiMap<String, String>> itemValueCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<AssociationModel, BiMap<String, String>>(){

        public BiMap<String, String> load(AssociationModel associationModel) {
            return AssociationModelEvaluator.parseItemValues(associationModel);
        }
    });

    public AssociationModelEvaluator(PMML pmml) {
        this(pmml, (AssociationModel)AssociationModelEvaluator.find((List)pmml.getModels(), AssociationModel.class));
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
    }

    public String getSummary() {
        return "Association rules";
    }

    public FieldName getActiveField() {
        List activeFields = this.getActiveFields();
        if (activeFields.size() < 1) {
            throw new InvalidFeatureException("No active fields", (PMMLObject)this.getMiningSchema());
        }
        if (activeFields.size() > 1) {
            throw new InvalidFeatureException("Too many active fields", (PMMLObject)this.getMiningSchema());
        }
        return (FieldName)activeFields.get(0);
    }

    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ?> predictions;
        AssociationModel associationModel = (AssociationModel)this.getModel();
        if (!associationModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)associationModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = associationModel.getFunctionName();
        switch (miningFunction) {
            case ASSOCIATION_RULES: {
                predictions = this.evaluate(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)associationModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluate(EvaluationContext context) {
        Collection values;
        AssociationModel associationModel = (AssociationModel)this.getModel();
        FieldName activeField = this.getActiveField();
        FieldValue value = context.getArgument(activeField);
        if (value == null) {
            throw new MissingFieldException(activeField, (PMMLObject)associationModel);
        }
        try {
            values = (Collection)FieldValueUtil.getValue(value);
        }
        catch (ClassCastException cce) {
            throw new TypeCheckException(Collection.class, value);
        }
        Set<String> input = this.createInput(values, context);
        LinkedHashMap flags = Maps.newLinkedHashMap();
        List itemsets = associationModel.getItemsets();
        for (Itemset itemset : itemsets) {
            flags.put(itemset.getId(), AssociationModelEvaluator.isSubset(input, itemset));
        }
        List associationRules = associationModel.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        for (int i = 0; i < associationRules.size(); ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            Boolean antecedentFlag = (Boolean)flags.get(associationRule.getAntecedent());
            if (antecedentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            antecedentFlags.set(i, antecedentFlag);
            Boolean consequentFlag = (Boolean)flags.get(associationRule.getConsequent());
            if (consequentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public BiMap<String, Item> getItemRegistry() {
                return AssociationModelEvaluator.this.getItemRegistry();
            }

            @Override
            public BiMap<String, Itemset> getItemsetRegistry() {
                return AssociationModelEvaluator.this.getItemsetRegistry();
            }

            @Override
            public BiMap<String, AssociationRule> getAssociationRuleRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }
        };
        return Collections.singletonMap(this.getTargetField(), association);
    }

    private Set<String> createInput(Collection<?> values, EvaluationContext context) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        BiMap valueItems = this.getItemValues().inverse();
        for (Object value : values) {
            String stringValue = TypeUtil.format(value);
            String id = (String)valueItems.get(stringValue);
            if (id == null) {
                context.addWarning("Unknown item value \"" + stringValue + "\"");
                continue;
            }
            result.add(id);
        }
        return result;
    }

    private static boolean isSubset(Set<String> input, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            if (result &= input.contains(itemRef.getItemRef())) continue;
            return false;
        }
        return result;
    }

    private BiMap<String, Item> getItemRegistry() {
        return this.getValue(itemCache);
    }

    private BiMap<String, Itemset> getItemsetRegistry() {
        return this.getValue(itemsetCache);
    }

    private BiMap<String, String> getItemValues() {
        return this.getValue(itemValueCache);
    }

    private static BiMap<String, String> parseItemValues(AssociationModel associationModel) {
        HashBiMap result = HashBiMap.create();
        List items = associationModel.getItems();
        for (Item item : items) {
            result.put((Object)item.getId(), (Object)item.getValue());
        }
        return result;
    }
}

