/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public abstract class FieldValue
implements Serializable {
    private DataType dataType = null;
    private Object value = null;

    public FieldValue(DataType dataType, Object value) {
        this.setDataType(dataType);
        this.setValue(value);
    }

    public abstract OpType getOpType();

    public boolean equalsString(String string) {
        return TypeUtil.equals(this.getDataType(), this.getValue(), this.parseValue(string));
    }

    public boolean equalsAnyString(Iterable<String> strings) {
        for (String string : strings) {
            boolean equals = this.equalsString(string);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public boolean equalsValue(FieldValue value) {
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.equals(dataType, this.getValue(), value.getValue());
    }

    public boolean equalsAnyValue(Iterable<FieldValue> values) {
        for (FieldValue value : values) {
            boolean equals = this.equalsValue(value);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public int compareToString(String string) {
        return TypeUtil.compare(this.getDataType(), this.getValue(), this.parseValue(string));
    }

    public int compareToValue(FieldValue value) {
        DataType dataType = TypeUtil.getResultDataType(this.getDataType(), value.getDataType());
        return TypeUtil.compare(dataType, this.getValue(), value.getValue());
    }

    public Object parseValue(String string) {
        DataType dataType = this.getDataType();
        return TypeUtil.parse(dataType, string);
    }

    public String asString() {
        Object value = this.getValue();
        if (value instanceof String) {
            return (String)value;
        }
        throw new TypeCheckException(DataType.STRING, value);
    }

    public Integer asInteger() {
        Object value = this.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new TypeCheckException(DataType.INTEGER, value);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new TypeCheckException(DataType.DOUBLE, value);
    }

    public Boolean asBoolean() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new TypeCheckException(DataType.BOOLEAN, value);
    }

    public LocalDate asLocalDate() {
        Object value = this.getValue();
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalDate();
        }
        throw new TypeCheckException(DataType.DATE, value);
    }

    public LocalTime asLocalTime() {
        Object value = this.getValue();
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalTime();
        }
        throw new TypeCheckException(DataType.TIME, value);
    }

    public LocalDateTime asLocalDateTime() {
        Object value = this.getValue();
        if (value instanceof LocalDate) {
            LocalDate instant = (LocalDate)value;
            return new LocalDateTime(instant.getYear(), instant.getMonthOfYear(), instant.getDayOfMonth(), 0, 0, 0);
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new TypeCheckException(DataType.DATE_TIME, value);
    }

    public DateTime asDateTime() {
        Object value = this.getValue();
        if (value instanceof LocalDate) {
            LocalDate instant = (LocalDate)value;
            return instant.toDateTimeAtStartOfDay();
        }
        if (value instanceof LocalTime) {
            LocalTime instant = (LocalTime)value;
            return instant.toDateTimeToday();
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toDateTime();
        }
        throw new TypeCheckException(DataType.DATE_TIME, value);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass()).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("value", this.getValue());
        return helper.toString();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException();
        }
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }
}

