/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionEvaluationContext;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class FunctionUtil {
    private static final Map<String, Function> functions = Maps.newLinkedHashMap();

    private FunctionUtil() {
    }

    public static FieldValue evaluate(Apply apply, List<FieldValue> values, EvaluationContext context) {
        String name = apply.getFunction();
        Function function = FunctionUtil.getFunction(name);
        if (function == null) {
            DefineFunction defineFunction = context.resolveFunction(name);
            if (defineFunction == null) {
                throw new UnsupportedFeatureException((PMMLObject)apply);
            }
            return FunctionUtil.evaluate(defineFunction, values, context);
        }
        return function.evaluate(values);
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException();
        }
        LinkedHashMap arguments = Maps.newLinkedHashMap();
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = values.get(i);
            arguments.put(parameterField.getName(), FieldValueUtil.refine((Field)parameterField, value));
        }
        Expression expression = defineFunction.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        FunctionEvaluationContext functionContext = new FunctionEvaluationContext(context);
        functionContext.pushFrame(arguments);
        FieldValue result = ExpressionUtil.evaluate(expression, (EvaluationContext)functionContext);
        return FieldValueUtil.refine(defineFunction.getDataType(), defineFunction.getOptype(), result);
    }

    public static Function getFunction(String name) {
        return functions.get(name);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    private static void checkArguments(List<FieldValue> values, int size) {
        FunctionUtil.checkArguments(values, size, false);
    }

    private static void checkArguments(List<FieldValue> values, int size, boolean allowNulls) {
        boolean success;
        boolean bl = success = values.size() == size && (allowNulls || !values.contains(null));
        if (!success) {
            throw new EvaluationException();
        }
    }

    private static void checkVariableArguments(List<FieldValue> values, int size) {
        FunctionUtil.checkVariableArguments(values, size, false);
    }

    private static void checkVariableArguments(List<FieldValue> values, int size, boolean allowNulls) {
        boolean success;
        boolean bl = success = values.size() >= size && (allowNulls || !values.contains(null));
        if (!success) {
            throw new EvaluationException();
        }
    }

    private static Number cast(DataType dataType, Number number) {
        switch (dataType) {
            case INTEGER: {
                if (number instanceof Integer) {
                    return number;
                }
                return number.intValue();
            }
            case FLOAT: {
                if (number instanceof Float) {
                    return number;
                }
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                if (number instanceof Double) {
                    return number;
                }
                return number.doubleValue();
            }
        }
        throw new EvaluationException();
    }

    private static DataType integerToDouble(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }

    static {
        FunctionUtil.putFunction("+", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() + right.doubleValue();
            }
        });
        FunctionUtil.putFunction("-", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() - right.doubleValue();
            }
        });
        FunctionUtil.putFunction("*", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() * right.doubleValue();
            }
        });
        FunctionUtil.putFunction("/", new ArithmeticFunction(){

            @Override
            public Number evaluate(Number left, Number right) {
                if (left instanceof Integer && right instanceof Integer) {
                    return left.intValue() / right.intValue();
                }
                return left.doubleValue() / right.doubleValue();
            }
        });
        FunctionUtil.putFunction("min", new AggregateFunction(){

            public Min createStatistic() {
                return new Min();
            }
        });
        FunctionUtil.putFunction("max", new AggregateFunction(){

            public Max createStatistic() {
                return new Max();
            }
        });
        FunctionUtil.putFunction("avg", new AggregateFunction(){

            public Mean createStatistic() {
                return new Mean();
            }

            @Override
            public DataType getResultType(DataType dataType) {
                return FunctionUtil.integerToDouble(dataType);
            }
        });
        FunctionUtil.putFunction("sum", new AggregateFunction(){

            public Sum createStatistic() {
                return new Sum();
            }
        });
        FunctionUtil.putFunction("product", new AggregateFunction(){

            public Product createStatistic() {
                return new Product();
            }
        });
        FunctionUtil.putFunction("log10", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log10(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("ln", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("exp", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.exp(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("sqrt", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.sqrt(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("abs", new MathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.abs(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("pow", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                FieldValue left = values.get(0);
                FieldValue right = values.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Double result = Math.pow(left.asNumber().doubleValue(), right.asNumber().doubleValue());
                return FieldValueUtil.create(FunctionUtil.cast(dataType, result));
            }
        });
        FunctionUtil.putFunction("threshold", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                FieldValue left = values.get(0);
                FieldValue right = values.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Integer result = left.asNumber().doubleValue() > right.asNumber().doubleValue() ? 1 : 0;
                return FieldValueUtil.create(FunctionUtil.cast(dataType, result));
            }
        });
        FunctionUtil.putFunction("floor", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.floor(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("ceil", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.ceil(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("round", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.round(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("isMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value == null;
            }
        });
        FunctionUtil.putFunction("isNotMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value != null;
            }
        });
        FunctionUtil.putFunction("equal", new EqualityFunction(){

            @Override
            public Boolean evaluate(boolean equals) {
                return equals;
            }
        });
        FunctionUtil.putFunction("notEqual", new EqualityFunction(){

            @Override
            public Boolean evaluate(boolean equals) {
                return !equals;
            }
        });
        FunctionUtil.putFunction("lessThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order < 0;
            }
        });
        FunctionUtil.putFunction("lessOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order <= 0;
            }
        });
        FunctionUtil.putFunction("greaterThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order > 0;
            }
        });
        FunctionUtil.putFunction("greaterOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order >= 0;
            }
        });
        FunctionUtil.putFunction("and", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left & right;
            }
        });
        FunctionUtil.putFunction("or", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left | right;
            }
        });
        FunctionUtil.putFunction("not", new UnaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean value) {
                return value == false;
            }
        });
        FunctionUtil.putFunction("isIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return value.equalsAnyValue(values);
            }
        });
        FunctionUtil.putFunction("isNotIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return !value.equalsAnyValue(values);
            }
        });
        FunctionUtil.putFunction("if", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FieldValue falseValue;
                if (values.size() < 2 || values.size() > 3) {
                    throw new EvaluationException();
                }
                FieldValue flag = values.get(0);
                if (flag == null) {
                    throw new EvaluationException();
                }
                if (flag.asBoolean().booleanValue()) {
                    FieldValue trueValue = values.get(1);
                    if (trueValue == null) {
                        throw new EvaluationException();
                    }
                    return trueValue;
                }
                FieldValue fieldValue = falseValue = values.size() > 2 ? values.get(2) : null;
                if (falseValue == null) {
                    return null;
                }
                return falseValue;
            }
        });
        FunctionUtil.putFunction("uppercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toUpperCase();
            }
        });
        FunctionUtil.putFunction("lowercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toLowerCase();
            }
        });
        FunctionUtil.putFunction("substring", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 3);
                String string = values.get(0).asString();
                int position = values.get(1).asInteger();
                int length = values.get(2).asInteger();
                if (position <= 0 || length < 0) {
                    throw new EvaluationException();
                }
                String result = string.substring(position - 1, position + length - 1);
                return FieldValueUtil.create(result);
            }
        });
        FunctionUtil.putFunction("trimBlanks", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.trim();
            }
        });
        FunctionUtil.putFunction("formatNumber", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                FieldValue value = values.get(0);
                FieldValue pattern = values.get(1);
                String result = String.format(pattern.asString(), value.asNumber());
                return FieldValueUtil.create(result);
            }
        });
        FunctionUtil.putFunction("formatDatetime", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                FieldValue value = values.get(0);
                FieldValue pattern = values.get(1);
                String result = String.format(this.translatePattern(pattern.asString()), value.asDateTime().toDate());
                return FieldValueUtil.create(result);
            }

            private String translatePattern(String pattern) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < pattern.length(); ++i) {
                    char c = pattern.charAt(i);
                    sb.append(c);
                    if (c != '%' || i >= pattern.length() - 1 || pattern.charAt(i + 1) == '%') continue;
                    sb.append("1$t");
                }
                return sb.toString();
            }
        });
        FunctionUtil.putFunction("dateDaysSinceYear", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                LocalDate instant = values.get(0).asLocalDate();
                int year = values.get(1).asInteger();
                DaysSinceDate period = new DaysSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionUtil.putFunction("dateSecondsSinceMidnight", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 1);
                LocalTime instant = values.get(0).asLocalTime();
                Seconds seconds = Seconds.seconds((int)(instant.getHourOfDay() * 60 * 60 + instant.getMinuteOfHour() * 60 + instant.getSecondOfMinute()));
                SecondsSinceMidnight period = new SecondsSinceMidnight(seconds);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionUtil.putFunction("dateSecondsSinceYear", new Function(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FunctionUtil.checkArguments(values, 2);
                LocalDateTime instant = values.get(0).asLocalDateTime();
                int year = values.get(1).asInteger();
                SecondsSinceDate period = new SecondsSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
    }

    public static abstract class StringFunction
    implements Function {
        public abstract String evaluate(String var1);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 1);
            FieldValue value = values.get(0);
            String result = this.evaluate(value.asString());
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class ValueListFunction
    implements Function {
        public abstract Boolean evaluate(FieldValue var1, List<FieldValue> var2);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkVariableArguments(values, 2);
            Boolean result = this.evaluate(values.get(0), values.subList(1, values.size()));
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class UnaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 1);
            FieldValue value = values.get(0);
            Boolean result = this.evaluate(value.asBoolean());
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class BinaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1, Boolean var2);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkVariableArguments(values, 2);
            Boolean result = values.get(0).asBoolean();
            for (int i = 1; i < values.size(); ++i) {
                result = this.evaluate(result, values.get(i).asBoolean());
            }
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class ComparisonFunction
    implements Function {
        public abstract Boolean evaluate(int var1);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 2);
            FieldValue left = values.get(0);
            FieldValue right = values.get(1);
            Boolean result = this.evaluate(left.compareToValue(right));
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class EqualityFunction
    implements Function {
        public abstract Boolean evaluate(boolean var1);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 2);
            FieldValue left = values.get(0);
            FieldValue right = values.get(1);
            Boolean result = this.evaluate(left.equalsValue(right));
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class ValueFunction
    implements Function {
        public abstract Boolean evaluate(FieldValue var1);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 1, true);
            FieldValue value = values.get(0);
            Boolean result = this.evaluate(value);
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class FpMathFunction
    extends MathFunction {
        @Override
        public DataType getResultType(DataType dataType) {
            return FunctionUtil.integerToDouble(dataType);
        }
    }

    public static abstract class MathFunction
    implements Function {
        public abstract Double evaluate(Number var1);

        public DataType getResultType(DataType dataType) {
            return dataType;
        }

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            FunctionUtil.checkArguments(values, 1);
            FieldValue value = values.get(0);
            Number result = FunctionUtil.cast(this.getResultType(value.getDataType()), this.evaluate(value.asNumber()));
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class AggregateFunction
    implements Function {
        public abstract StorelessUnivariateStatistic createStatistic();

        public DataType getResultType(DataType dataType) {
            return dataType;
        }

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            StorelessUnivariateStatistic statistic = this.createStatistic();
            DataType dataType = null;
            for (FieldValue value : values) {
                if (value == null) continue;
                statistic.increment(value.asNumber().doubleValue());
                if (dataType != null) {
                    dataType = TypeUtil.getResultDataType(dataType, value.getDataType());
                    continue;
                }
                dataType = value.getDataType();
            }
            if (statistic.getN() == 0L) {
                throw new MissingResultException(null);
            }
            Number result = FunctionUtil.cast(this.getResultType(dataType), statistic.getResult());
            return FieldValueUtil.create(result);
        }
    }

    public static abstract class ArithmeticFunction
    implements Function {
        public abstract Number evaluate(Number var1, Number var2);

        @Override
        public FieldValue evaluate(List<FieldValue> values) {
            Number result;
            if (values.size() != 2) {
                throw new EvaluationException();
            }
            FieldValue left = values.get(0);
            FieldValue right = values.get(1);
            if (left == null || right == null) {
                return null;
            }
            DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
            try {
                result = this.evaluate(left.asNumber(), right.asNumber());
            }
            catch (ArithmeticException ae) {
                throw new InvalidResultException(null);
            }
            return FieldValueUtil.create(FunctionUtil.cast(dataType, result));
        }
    }

    public static interface Function {
        public FieldValue evaluate(List<FieldValue> var1);
    }
}

