/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.KernelType;
import org.dmg.pmml.LinearKernelType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PolynomialKernelType;
import org.dmg.pmml.RadialBasisKernelType;
import org.dmg.pmml.SigmoidKernelType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.manager.UnsupportedFeatureException;

public class KernelTypeUtil {
    private KernelTypeUtil() {
    }

    public static double evaluate(KernelType kernelType, double[] input, double[] vector) {
        if (kernelType instanceof LinearKernelType) {
            return KernelTypeUtil.evaluateLinearKernel((LinearKernelType)kernelType, input, vector);
        }
        if (kernelType instanceof PolynomialKernelType) {
            return KernelTypeUtil.evaluatePolynomialKernel((PolynomialKernelType)kernelType, input, vector);
        }
        if (kernelType instanceof RadialBasisKernelType) {
            return KernelTypeUtil.evaluateRadialBasisKernel((RadialBasisKernelType)kernelType, input, vector);
        }
        if (kernelType instanceof SigmoidKernelType) {
            return KernelTypeUtil.evaluateSigmoidKernel((SigmoidKernelType)kernelType, input, vector);
        }
        throw new UnsupportedFeatureException((PMMLObject)kernelType);
    }

    public static double evaluateLinearKernel(LinearKernelType linearKernelType, double[] input, double[] vector) {
        return KernelTypeUtil.dotProduct(input, vector);
    }

    public static double evaluatePolynomialKernel(PolynomialKernelType polynomialKernelType, double[] input, double[] vector) {
        return Math.pow(polynomialKernelType.getGamma() * KernelTypeUtil.dotProduct(input, vector) + polynomialKernelType.getCoef0(), polynomialKernelType.getDegree());
    }

    public static double evaluateRadialBasisKernel(RadialBasisKernelType radialBasisKernelType, double[] input, double[] vector) {
        return Math.exp(-radialBasisKernelType.getGamma() * KernelTypeUtil.squaredDistance(input, vector));
    }

    public static double evaluateSigmoidKernel(SigmoidKernelType sigmoidKernelType, double[] input, double[] vector) {
        return Math.tanh(sigmoidKernelType.getGamma() * KernelTypeUtil.dotProduct(input, vector) + sigmoidKernelType.getCoef0());
    }

    private static double dotProduct(double[] left, double[] right) {
        double sum = 0.0;
        if (left.length != right.length) {
            throw new EvaluationException();
        }
        for (int i = 0; i < left.length; ++i) {
            sum += left[i] * right[i];
        }
        return sum;
    }

    private static double squaredDistance(double[] left, double[] right) {
        double sum = 0.0;
        if (left.length != right.length) {
            throw new EvaluationException();
        }
        for (int i = 0; i < left.length; ++i) {
            double diff = left[i] - right[i];
            sum += diff * diff;
        }
        return sum;
    }
}

