/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.CompoundRule;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Rule;
import org.dmg.pmml.RuleSelectionMethod;
import org.dmg.pmml.RuleSet;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.SimpleRule;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.RuleClassificationMap;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class RuleSetModelEvaluator
extends ModelEvaluator<RuleSetModel> {
    public RuleSetModelEvaluator(PMML pmml) {
        this(pmml, (RuleSetModel)RuleSetModelEvaluator.find((List)pmml.getModels(), RuleSetModel.class));
    }

    public RuleSetModelEvaluator(PMML pmml, RuleSetModel ruleSetModel) {
        super(pmml, ruleSetModel);
    }

    public String getSummary() {
        return "Ruleset model";
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ? extends ClassificationMap> predictions;
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        if (!ruleSetModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)ruleSetModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = ruleSetModel.getFunctionName();
        switch (miningFunction) {
            case CLASSIFICATION: {
                predictions = this.evaluateRuleSet(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)ruleSetModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends ClassificationMap> evaluateRuleSet(ModelManagerEvaluationContext context) {
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        List ruleSelectionMethods = ruleSet.getRuleSelectionMethods();
        if (ruleSelectionMethods.size() <= 0) {
            throw new InvalidFeatureException((PMMLObject)ruleSet);
        }
        RuleSelectionMethod ruleSelectionMethod = (RuleSelectionMethod)ruleSelectionMethods.get(0);
        LinkedListMultimap firedRules = LinkedListMultimap.create();
        List rules = ruleSet.getRules();
        for (Rule rule : rules) {
            RuleSetModelEvaluator.collectFiredRules((ListMultimap<String, SimpleRule>)firedRules, rule, context);
        }
        RuleClassificationMap result = new RuleClassificationMap();
        RuleSelectionMethod.Criterion criterion = ruleSelectionMethod.getCriterion();
        Set keys = firedRules.keySet();
        block6: for (String key : keys) {
            List keyRules = firedRules.get((Object)key);
            switch (criterion) {
                case FIRST_HIT: {
                    SimpleRule winner = (SimpleRule)keyRules.get(0);
                    if (result.getEntity() == null) {
                        result.setEntity(winner);
                    }
                    result.put(key, winner.getConfidence());
                    continue block6;
                }
                case WEIGHTED_SUM: {
                    SimpleRule winner = null;
                    double totalWeight = 0.0;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner == null || winner.getWeight() < keyRule.getWeight()) {
                            winner = keyRule;
                        }
                        totalWeight += keyRule.getWeight().doubleValue();
                    }
                    result.put(winner, key, totalWeight / (double)firedRules.size());
                    continue block6;
                }
                case WEIGHTED_MAX: {
                    SimpleRule winner = null;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner != null && !(winner.getWeight() < keyRule.getWeight())) continue;
                        winner = keyRule;
                    }
                    result.put(winner, key, winner.getConfidence());
                    continue block6;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)ruleSelectionMethod, (Enum)criterion);
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private static void collectFiredRules(ListMultimap<String, SimpleRule> firedRules, Rule rule, EvaluationContext context) {
        Predicate predicate = rule.getPredicate();
        if (predicate == null) {
            throw new InvalidFeatureException((PMMLObject)rule);
        }
        Boolean status = PredicateUtil.evaluate(predicate, context);
        if (status == null || !status.booleanValue()) {
            return;
        }
        if (rule instanceof SimpleRule) {
            SimpleRule simpleRule = (SimpleRule)rule;
            firedRules.put((Object)simpleRule.getScore(), (Object)simpleRule);
        } else if (rule instanceof CompoundRule) {
            CompoundRule compoundRule = (CompoundRule)rule;
            List childRules = compoundRule.getRules();
            for (Rule childRule : childRules) {
                RuleSetModelEvaluator.collectFiredRules(firedRules, childRule, context);
            }
        }
    }
}

