/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DataType;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PoissonDistribution;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class DistributionUtil {
    private DistributionUtil() {
    }

    public static double probability(ContinuousDistribution distribution, Number x) {
        if (distribution instanceof GaussianDistribution) {
            return DistributionUtil.probability((GaussianDistribution)distribution, x);
        }
        if (distribution instanceof PoissonDistribution) {
            return DistributionUtil.probability((PoissonDistribution)distribution, x);
        }
        throw new UnsupportedFeatureException((PMMLObject)distribution);
    }

    public static double probability(GaussianDistribution gaussianDistribution, Number x) {
        NormalDistribution distribution = new NormalDistribution(gaussianDistribution.getMean(), Math.sqrt(gaussianDistribution.getVariance()));
        return distribution.density(x.doubleValue());
    }

    public static double probability(PoissonDistribution poissonDistribution, Number x) {
        org.apache.commons.math3.distribution.PoissonDistribution distribution = new org.apache.commons.math3.distribution.PoissonDistribution(null, poissonDistribution.getMean(), 1.0E-12, 10000000);
        x = (Number)TypeUtil.cast(DataType.INTEGER, (Object)x);
        return distribution.probability(x.intValue());
    }
}

