/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.True;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MiningModelConsumer;
import org.jpmml.evaluator.MiningModelEvaluationContext;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ProbabilityAggregator;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.RegressionAggregator;
import org.jpmml.evaluator.SegmentResult;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.VoteAggregator;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements MiningModelConsumer,
HasEntityRegistry<Segment> {
    private transient List<FieldName> nestedOutputFieldNames = null;
    private Map<FieldName, OutputField> nestedOutputFields = Collections.emptyMap();
    private ModelEvaluatorFactory evaluatorFactory = null;
    private ConcurrentMap<String, SegmentHandler> segmentHandlers = new ConcurrentHashMap<String, SegmentHandler>();
    private transient BiMap<String, Segment> entityRegistry = null;
    private static final Set<MultipleModelMethodType> REGRESSION_METHODS = EnumSet.of(MultipleModelMethodType.SUM, MultipleModelMethodType.MEDIAN, MultipleModelMethodType.AVERAGE, MultipleModelMethodType.WEIGHTED_AVERAGE);
    private static final Set<MultipleModelMethodType> CLASSIFICATION_METHODS = EnumSet.of(MultipleModelMethodType.MAJORITY_VOTE, new MultipleModelMethodType[]{MultipleModelMethodType.WEIGHTED_MAJORITY_VOTE, MultipleModelMethodType.SUM, MultipleModelMethodType.MEDIAN, MultipleModelMethodType.AVERAGE, MultipleModelMethodType.WEIGHTED_AVERAGE});
    private static final Set<MultipleModelMethodType> CLUSTERING_METHODS = EnumSet.of(MultipleModelMethodType.MAJORITY_VOTE, MultipleModelMethodType.WEIGHTED_MAJORITY_VOTE);
    private static final LoadingCache<MiningModel, BiMap<String, Segment>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningModel, BiMap<String, Segment>>(){

        public BiMap<String, Segment> load(MiningModel miningModel) {
            Segmentation segmentation = miningModel.getSegmentation();
            return EntityUtil.buildBiMap(segmentation.getSegments());
        }
    });

    public MiningModelEvaluator(PMML pmml) {
        this(pmml, MiningModelEvaluator.selectModel(pmml, MiningModel.class));
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            throw new InvalidFeatureException((PMMLObject)miningModel);
        }
        List segments = segmentation.getSegments();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                break;
            }
            case SELECT_FIRST: {
                this.nestedOutputFields = this.collectNestedOutputFields(this.getActiveHead(segments));
                break;
            }
            case MODEL_CHAIN: {
                this.nestedOutputFields = this.collectNestedOutputFields(this.getActiveTail(segments));
                break;
            }
        }
    }

    @Override
    public MultipleModelMethodType getMultipleModelMethod() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        return segmentation.getMultipleModelMethod();
    }

    @Override
    public List<FieldName> getNestedOutputFields() {
        if (this.nestedOutputFieldNames == null) {
            this.nestedOutputFieldNames = ImmutableList.copyOf(this.nestedOutputFields.keySet());
        }
        return this.nestedOutputFieldNames;
    }

    @Override
    public OutputField getNestedOutputField(FieldName name) {
        return this.nestedOutputFields.get(name);
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    protected DataField getDataField() {
        MultipleModelMethodType multipleModelMethod = this.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: 
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        MiningModelEvaluationContext context = new MiningModelEvaluationContext(this);
        context.setArguments(arguments);
        return this.evaluate((ModelEvaluationContext)context);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        return this.evaluate((MiningModelEvaluationContext)context);
    }

    public Map<FieldName, ?> evaluate(MiningModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (!miningModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)miningModel);
        }
        if (miningModel.hasEmbeddedModels()) {
            EmbeddedModel embeddedModel = (EmbeddedModel)Iterables.get((Iterable)miningModel.getEmbeddedModels(), (int)0);
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                predictions = this.evaluateAny(context);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(REGRESSION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Double result = MiningModelEvaluator.aggregateValues(segmentation, segmentResults);
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ?> evaluateClassification(MiningModelEvaluationContext context) {
        Classification result;
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLASSIFICATION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                result = new ProbabilityDistribution();
                result.putAll(MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
                result.normalizeValues();
                break;
            }
            case MAX: 
            case MEDIAN: {
                result = new Classification(Classification.Type.VOTE);
                result.putAll(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults));
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                result = new ProbabilityDistribution();
                result.putAll(MiningModelEvaluator.aggregateProbabilities(segmentation, segmentResults));
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Map<FieldName, ?> evaluateClustering(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLUSTERING_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Classification result = new Classification(Classification.Type.VOTE);
        result.putAll(MiningModelEvaluator.aggregateVotes(segmentation, segmentResults));
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private Map<FieldName, ?> evaluateAny(MiningModelEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluateSegmentation(context);
        return this.getSegmentationResult(Collections.emptySet(), segmentResults);
    }

    private List<SegmentResult> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedFeatureException((PMMLObject)localTransformations);
        }
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        ModelEvaluationContext miningModelContext = null;
        ModelEvaluationContext modelContext = null;
        List segments = segmentation.getSegments();
        ArrayList<SegmentResult> segmentResults = new ArrayList<SegmentResult>(segments.size());
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            SegmentResult segmentResult;
            ModelEvaluationContext segmentContext;
            ModelEvaluator segmentEvaluator;
            Segment segment = (Segment)segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            Boolean status = PredicateUtil.evaluate(predicate, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
                default: {
                    if (miningFunction.equals((Object)model.getFunctionName())) break;
                    throw new InvalidFeatureException((PMMLObject)model);
                }
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            if ((segmentEvaluator = (ModelEvaluator)segmentHandler.getEvaluator()) instanceof MiningModelEvaluator) {
                MiningModelEvaluator segmentMiningEvaluator = (MiningModelEvaluator)segmentEvaluator;
                if (miningModelContext == null) {
                    miningModelContext = new MiningModelEvaluationContext(context, segmentMiningEvaluator);
                } else {
                    miningModelContext.reset(segmentMiningEvaluator);
                }
                segmentContext = miningModelContext;
            } else {
                if (modelContext == null) {
                    modelContext = new ModelEvaluationContext(context, segmentEvaluator);
                } else {
                    modelContext.reset(segmentEvaluator);
                }
                segmentContext = modelContext;
            }
            segmentContext.setCompatible(segmentHandler.isCompatible());
            try {
                Map<FieldName, ?> result = segmentEvaluator.evaluate(segmentContext);
                FieldName segmentTargetField = segmentEvaluator.getTargetField();
                segmentResult = new SegmentResult(segment, segmentId, result, segmentTargetField);
            }
            catch (PMMLException pe) {
                pe.ensureContext((PMMLObject)segment);
                throw pe;
            }
            context.putResult(segmentId, segmentResult);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    List<FieldName> outputFields = segmentEvaluator.getOutputFields();
                    for (FieldName outputField : outputFields) {
                        OutputField segmentOutputField = segmentEvaluator.getOutputField(outputField);
                        if (outputField == null) {
                            throw new MissingFieldException(outputField, (PMMLObject)segment);
                        }
                        context.putOutputField(segmentOutputField);
                        FieldValue outputValue = segmentContext.getField(outputField);
                        if (outputValue == null) {
                            throw new MissingValueException(outputField, (PMMLObject)segment);
                        }
                        context.declare(outputField, outputValue);
                    }
                    break;
                }
            }
            List<String> segmentWarnings = segmentContext.getWarnings();
            for (String segmentWarning : segmentWarnings) {
                context.addWarning(segmentWarning);
            }
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(segmentResult);
                }
            }
            segmentResults.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null || miningFunction.equals((Object)lastModel.getFunctionName())) break;
                throw new InvalidFeatureException((PMMLObject)lastModel);
            }
        }
        return segmentResults;
    }

    private Map<FieldName, ?> getSegmentationResult(Set<MultipleModelMethodType> multipleModelMethods, List<SegmentResult> segmentResults) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_ALL: {
                return MiningModelEvaluator.selectAll(segmentResults);
            }
            case SELECT_FIRST: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(0));
            }
            case MODEL_CHAIN: {
                if (segmentResults.size() <= 0) break;
                return (Map)((Object)segmentResults.get(segmentResults.size() - 1));
            }
            default: {
                if (multipleModelMethods.contains(multipleModelMethod)) break;
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        if (segmentResults.size() == 0) {
            return Collections.singletonMap(this.getTargetField(), null);
        }
        return null;
    }

    private Map<FieldName, OutputField> collectNestedOutputFields(List<Segment> segments) {
        LinkedHashMap<FieldName, OutputField> result = new LinkedHashMap<FieldName, OutputField>();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            SegmentHandler segmentHandler = (SegmentHandler)this.segmentHandlers.get(segmentId);
            if (segmentHandler == null) {
                segmentHandler = this.createSegmentHandler(model);
                this.segmentHandlers.putIfAbsent(segmentId, segmentHandler);
            }
            Evaluator evaluator = segmentHandler.getEvaluator();
            List<FieldName> names = EvaluatorUtil.getOutputFields(evaluator);
            for (FieldName name : names) {
                OutputField outputField = EvaluatorUtil.getOutputField(evaluator, name);
                result.put(name, outputField);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private List<Segment> getActiveHead(List<Segment> segments) {
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            if (!(predicate instanceof True)) continue;
            return segments.subList(0, i + 1);
        }
        return segments;
    }

    private List<Segment> getActiveTail(List<Segment> segments) {
        return Lists.reverse(this.getActiveHead(Lists.reverse(segments)));
    }

    private SegmentHandler createSegmentHandler(Model model) {
        ModelEvaluatorFactory evaluatorFactory = this.getEvaluatorFactory();
        if (evaluatorFactory == null) {
            evaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        ModelManager evaluator = evaluatorFactory.newModelManager(this.getPMML(), model);
        boolean compatible = true;
        List<FieldName> activeFields = evaluator.getActiveFields();
        for (FieldName activeField : activeFields) {
            MiningField miningField = ((ModelEvaluator)evaluator).getMiningField(activeField);
            DataField dataField = this.getDataField(activeField);
            if (dataField == null) continue;
            compatible &= MiningFieldUtil.isDefault(miningField);
        }
        SegmentHandler result = new SegmentHandler((Evaluator)((Object)evaluator), compatible);
        return result;
    }

    public ModelEvaluatorFactory getEvaluatorFactory() {
        return this.evaluatorFactory;
    }

    public void setEvaluatorFactory(ModelEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    private static Double aggregateValues(Segmentation segmentation, List<SegmentResult> segmentResults) {
        RegressionAggregator aggregator;
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MEDIAN: {
                aggregator = new RegressionAggregator(segmentResults.size());
                break;
            }
            default: {
                aggregator = new RegressionAggregator();
            }
        }
        double denominator = 0.0;
        block13: for (SegmentResult segmentResult : segmentResults) {
            Double value = (Double)segmentResult.getTargetValue(DataType.DOUBLE);
            switch (multipleModelMethod) {
                case MEDIAN: 
                case SUM: {
                    aggregator.add(value);
                    continue block13;
                }
                case AVERAGE: {
                    aggregator.add(value);
                    denominator += 1.0;
                    continue block13;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(value * weight);
                    denominator += weight;
                    continue block13;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case SUM: {
                return aggregator.sum();
            }
            case MEDIAN: {
                return aggregator.median();
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                return aggregator.average(denominator);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<String, Double> aggregateVotes(Segmentation segmentation, List<SegmentResult> segmentResults) {
        VoteAggregator<String> aggregator = new VoteAggregator<String>();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        block4: for (SegmentResult segmentResult : segmentResults) {
            String key = (String)segmentResult.getTargetValue(DataType.STRING);
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(key, 1.0);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    aggregator.add(key, segmentResult.getWeight());
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        return aggregator.sumMap();
    }

    private static Map<String, Double> aggregateProbabilities(Segmentation segmentation, List<SegmentResult> segmentResults) {
        ProbabilityAggregator aggregator;
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MEDIAN: {
                aggregator = new ProbabilityAggregator(segmentResults.size());
                break;
            }
            default: {
                aggregator = new ProbabilityAggregator();
            }
        }
        double denominator = 0.0;
        block13: for (SegmentResult segmentResult : segmentResults) {
            HasProbability hasProbability = segmentResult.getTargetValue(HasProbability.class);
            switch (multipleModelMethod) {
                case MAX: 
                case MEDIAN: {
                    aggregator.add(hasProbability);
                    continue block13;
                }
                case AVERAGE: {
                    aggregator.add(hasProbability);
                    denominator += 1.0;
                    continue block13;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = segmentResult.getWeight();
                    aggregator.add(hasProbability, weight);
                    denominator += weight;
                    continue block13;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
        }
        switch (multipleModelMethod) {
            case MAX: {
                return aggregator.maxMap();
            }
            case MEDIAN: {
                return aggregator.medianMap();
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: {
                return aggregator.averageMap(denominator);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
    }

    private static Map<FieldName, ?> selectAll(List<SegmentResult> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        LinkedHashSet keys = null;
        for (SegmentResult segmentResult : segmentResults) {
            if (keys == null) {
                keys = new LinkedHashSet(segmentResult.keySet());
            }
            if (!keys.equals(segmentResult.keySet())) {
                throw new EvaluationException();
            }
            for (FieldName key : keys) {
                result.put((Object)key, segmentResult.get(key));
            }
        }
        return result.asMap();
    }

    private static class SegmentHandler
    implements Serializable {
        private Evaluator evaluator = null;
        private boolean compatible = false;

        private SegmentHandler(Evaluator evaluator, boolean compatible) {
            this.setEvaluator(evaluator);
            this.setCompatible(compatible);
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        private void setEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        private void setCompatible(boolean compatible) {
            this.compatible = compatible;
        }
    }
}

