/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.PMMLManager;

public class PMMLEvaluationContext
extends EvaluationContext {
    private PMMLManager pmmlManager = null;

    PMMLEvaluationContext(PMMLManager pmmlManager) {
        this.setPmmlManager(pmmlManager);
    }

    @Override
    protected FieldValue createFieldValue(FieldName name, Object value) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DataField dataField = pmmlManager.getDataField(name);
        if (dataField == null) {
            throw new MissingFieldException(name);
        }
        return FieldValueUtil.create((Field)dataField, value);
    }

    @Override
    protected FieldValue resolve(FieldName name) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DerivedField derivedField = pmmlManager.getDerivedField(name);
        if (derivedField != null) {
            FieldValue value = ExpressionUtil.evaluate(derivedField, (EvaluationContext)this);
            return this.declare(name, value);
        }
        throw new MissingFieldException(name);
    }

    @Override
    protected DefineFunction getDefineFunction(String name) {
        PMMLManager pmmlManager = this.getPmmlManager();
        DefineFunction defineFunction = pmmlManager.getDefineFunction(name);
        return defineFunction;
    }

    public PMMLManager getPmmlManager() {
        return this.pmmlManager;
    }

    private void setPmmlManager(PMMLManager pmmlManager) {
        this.pmmlManager = pmmlManager;
    }
}

