/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public abstract class AggregateFunction
extends AbstractFunction {
    public AggregateFunction(String name) {
        super(name);
    }

    public abstract StorelessUnivariateStatistic createStatistic();

    public DataType getResultType(DataType dataType) {
        return dataType;
    }

    @Override
    public FieldValue evaluate(List<FieldValue> arguments) {
        StorelessUnivariateStatistic statistic = this.createStatistic();
        DataType dataType = null;
        Iterable values = Iterables.filter(arguments, (Predicate)Predicates.notNull());
        for (FieldValue value : values) {
            statistic.increment(value.asNumber().doubleValue());
            if (dataType != null) {
                dataType = TypeUtil.getResultDataType(dataType, value.getDataType());
                continue;
            }
            dataType = value.getDataType();
        }
        if (statistic.getN() == 0L) {
            throw new InvalidResultException(null);
        }
        Number result = AggregateFunction.cast(this.getResultType(dataType), statistic.getResult());
        return FieldValueUtil.create(result);
    }
}

