/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public class CategoricalValue
extends FieldValue {
    CategoricalValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public int compareToString(String string) {
        throw new EvaluationException();
    }

    @Override
    public int compareToValue(FieldValue value) {
        throw new EvaluationException();
    }

    public static CategoricalValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new CategoricalValue(dataType, value);
        }
        switch (dataType) {
            case STRING: {
                return new CategoricalString((String)value);
            }
            case BOOLEAN: {
                return new CategoricalBoolean((Boolean)value);
            }
        }
        return new CategoricalValue(dataType, value);
    }

    private static class CategoricalBoolean
    extends CategoricalValue
    implements FieldValue.Scalar {
        CategoricalBoolean(Boolean value) {
            super(DataType.BOOLEAN, value);
        }

        @Override
        public int compareToString(String string) {
            Number number;
            try {
                number = (Number)TypeUtil.parse(DataType.DOUBLE, string);
            }
            catch (NumberFormatException nfe) {
                throw new TypeCheckException(DataType.DOUBLE, (Object)string);
            }
            return TypeUtil.compare(DataType.DOUBLE, this.asBoolean(), number);
        }

        @Override
        public int compareToValue(FieldValue value) {
            Number number;
            try {
                number = value.asNumber();
            }
            catch (TypeCheckException tce) {
                throw new TypeCheckException(DataType.DOUBLE, value.getValue());
            }
            return TypeUtil.compare(DataType.DOUBLE, this.asBoolean(), number);
        }

        @Override
        public Boolean asBoolean() {
            return (Boolean)this.getValue();
        }
    }

    private static class CategoricalString
    extends CategoricalValue
    implements FieldValue.Scalar {
        CategoricalString(String value) {
            super(DataType.STRING, value);
        }

        @Override
        public String asString() {
            return (String)this.getValue();
        }
    }
}

