/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.evaluator.DoubleVector;

public abstract class ClassificationAggregator<K> {
    private Map<K, DoubleVector> map = new LinkedHashMap<K, DoubleVector>();
    private int capacity = 0;

    public ClassificationAggregator(int capacity) {
        this.capacity = capacity;
    }

    public int size() {
        return this.map.size();
    }

    public void add(K key, double value) {
        DoubleVector values = this.map.get(key);
        if (values == null) {
            values = new DoubleVector(this.capacity);
            this.map.put(key, values);
        }
        values.add(value);
    }

    public void clear() {
        this.map.clear();
    }

    protected DoubleVector get(K key) {
        return this.map.get(key);
    }

    protected <V> Map<K, V> transform(Function<DoubleVector, V> function) {
        return Maps.transformValues(this.map, function);
    }
}

